/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.BatchSuppressableTool;
import com.intellij.codeInspection.InjectionAwareSuppressQuickFix;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LanguageInspectionSuppressors;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.util.ResourceUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializer;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionProfileEntry
implements BatchSuppressableTool {
    public static final String GENERAL_GROUP_NAME = InspectionsBundle.message("inspection.general.tools.group.name", new Object[0]);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.InspectionProfileEntry");
    private static final SerializationFilter DEFAULT_FILTER = new SkipDefaultValuesSerializationFilters();
    private static Set<String> ourBlackList;
    private static final Object BLACK_LIST_LOCK;
    private Boolean myUseNewSerializer;
    protected volatile DefaultNameProvider myNameProvider;

    @NonNls
    @Nullable
    public String getAlternativeID() {
        return null;
    }

    @Override
    public boolean isSuppressedFor(@NotNull PsiElement element) {
        Set<InspectionSuppressor> suppressors = InspectionProfileEntry.getSuppressors(element);
        String toolId = this.getSuppressId();
        for (InspectionSuppressor suppressor : suppressors) {
            if (!this.isSuppressed(toolId, suppressor, element)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected String getSuppressId() {
        return this.getShortName();
    }

    @Override
    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        if (element == null) {
            return SuppressQuickFix.EMPTY_ARRAY;
        }
        THashSet fixes = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<SuppressQuickFix>(){

            public int computeHashCode(SuppressQuickFix object) {
                int result = object instanceof InjectionAwareSuppressQuickFix ? ((InjectionAwareSuppressQuickFix)object).isShouldBeAppliedToInjectionHost().hashCode() : 0;
                return 31 * result + object.getName().hashCode();
            }

            public boolean equals(SuppressQuickFix o1, SuppressQuickFix o2) {
                if (o1 instanceof InjectionAwareSuppressQuickFix && o2 instanceof InjectionAwareSuppressQuickFix && ((InjectionAwareSuppressQuickFix)o1).isShouldBeAppliedToInjectionHost() != ((InjectionAwareSuppressQuickFix)o2).isShouldBeAppliedToInjectionHost()) {
                    return false;
                }
                return o1.getName().equals(o2.getName());
            }
        });
        Set<InspectionSuppressor> suppressors = InspectionProfileEntry.getSuppressors(element);
        PsiLanguageInjectionHost injectionHost = InjectedLanguageManager.getInstance(element.getProject()).getInjectionHost(element);
        if (injectionHost != null) {
            Set<InspectionSuppressor> injectionHostSuppressors = InspectionProfileEntry.getSuppressors(injectionHost);
            for (InspectionSuppressor suppressor : injectionHostSuppressors) {
                InspectionProfileEntry.addAllSuppressActions((Set<SuppressQuickFix>)fixes, injectionHost, suppressor, ThreeState.YES, this.getSuppressId());
            }
        }
        for (InspectionSuppressor suppressor : suppressors) {
            InspectionProfileEntry.addAllSuppressActions((Set<SuppressQuickFix>)fixes, element, suppressor, injectionHost != null ? ThreeState.NO : ThreeState.UNSURE, this.getSuppressId());
        }
        return fixes.toArray(new SuppressQuickFix[fixes.size()]);
    }

    private static void addAllSuppressActions(@NotNull Set<SuppressQuickFix> fixes, @NotNull PsiElement element, @NotNull InspectionSuppressor suppressor, @NotNull ThreeState appliedToInjectionHost, @NotNull String toolId) {
        SuppressQuickFix[] actions;
        for (SuppressQuickFix action : actions = suppressor.getSuppressActions(element, toolId)) {
            if (action instanceof InjectionAwareSuppressQuickFix) {
                ((InjectionAwareSuppressQuickFix)action).setShouldBeAppliedToInjectionHost(appliedToInjectionHost);
            }
            fixes.add(action);
        }
    }

    private boolean isSuppressed(@NotNull String toolId, @NotNull InspectionSuppressor suppressor, @NotNull PsiElement element) {
        if (suppressor.isSuppressedFor(element, toolId)) {
            return true;
        }
        String alternativeId = this.getAlternativeID();
        return alternativeId != null && !alternativeId.equals(toolId) && suppressor.isSuppressedFor(element, alternativeId);
    }

    @NotNull
    public static Set<InspectionSuppressor> getSuppressors(@NotNull PsiElement element) {
        FileViewProvider viewProvider = element.getContainingFile().getViewProvider();
        InspectionSuppressor elementLanguageSuppressor = (InspectionSuppressor)LanguageInspectionSuppressors.INSTANCE.forLanguage(element.getLanguage());
        if (viewProvider instanceof TemplateLanguageFileViewProvider) {
            LinkedHashSet<InspectionSuppressor> suppressors = new LinkedHashSet<InspectionSuppressor>();
            ContainerUtil.addIfNotNull(suppressors, LanguageInspectionSuppressors.INSTANCE.forLanguage(viewProvider.getBaseLanguage()));
            for (Language language : viewProvider.getLanguages()) {
                ContainerUtil.addIfNotNull(suppressors, LanguageInspectionSuppressors.INSTANCE.forLanguage(language));
            }
            ContainerUtil.addIfNotNull(suppressors, (Object)elementLanguageSuppressor);
            return suppressors;
        }
        if (!element.getLanguage().isKindOf(viewProvider.getBaseLanguage())) {
            LinkedHashSet<InspectionSuppressor> suppressors = new LinkedHashSet<InspectionSuppressor>();
            ContainerUtil.addIfNotNull(suppressors, LanguageInspectionSuppressors.INSTANCE.forLanguage(viewProvider.getBaseLanguage()));
            ContainerUtil.addIfNotNull(suppressors, (Object)elementLanguageSuppressor);
            return suppressors;
        }
        return elementLanguageSuppressor != null ? Collections.singleton(elementLanguageSuppressor) : Collections.emptySet();
    }

    public void cleanup(@NotNull Project project) {
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String name;
        if (this.myNameProvider != null && (name = this.myNameProvider.getDefaultGroupDisplayName()) != null) {
            return name;
        }
        LOG.error(this.getClass() + ": group display name should be overridden or configured via XML " + this.getClass());
        return "";
    }

    @NotNull
    public String[] getGroupPath() {
        String groupDisplayName = this.getGroupDisplayName();
        if (groupDisplayName.isEmpty()) {
            groupDisplayName = GENERAL_GROUP_NAME;
        }
        return new String[]{groupDisplayName};
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String name;
        if (this.myNameProvider != null && (name = this.myNameProvider.getDefaultDisplayName()) != null) {
            return name;
        }
        LOG.error(this.getClass() + ": display name should be overridden or configured via XML " + this.getClass());
        return "";
    }

    @NonNls
    @NotNull
    public String getShortName() {
        String name;
        if (this.myNameProvider != null && (name = this.myNameProvider.getDefaultShortName()) != null) {
            return name;
        }
        return InspectionProfileEntry.getShortName(this.getClass().getSimpleName());
    }

    @NotNull
    public static String getShortName(@NotNull String className) {
        return StringUtil.trimEnd((String)StringUtil.trimEnd((String)className, (String)"Inspection"), (String)"InspectionBase");
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.WARNING;
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return null;
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (this.useNewSerializer()) {
            try {
                XmlSerializer.deserializeInto((Object)this, (Element)node);
            }
            catch (XmlSerializationException e) {
                throw new InvalidDataException((Throwable)e);
            }
        } else {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)node);
        }
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (this.useNewSerializer()) {
            XmlSerializer.serializeInto((Object)this, (Element)node, (SerializationFilter)this.getSerializationFilter());
        } else {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)node);
        }
    }

    private synchronized boolean useNewSerializer() {
        if (this.myUseNewSerializer == null) {
            this.myUseNewSerializer = !InspectionProfileEntry.getBlackList().contains(this.getClass().getName());
        }
        return this.myUseNewSerializer;
    }

    private static void loadBlackList() {
        ourBlackList = ContainerUtil.newHashSet();
        URL url = InspectionProfileEntry.class.getResource("inspection-black-list.txt");
        if (url == null) {
            LOG.error("Resource not found");
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                ourBlackList.add(line);
            }
        }
        catch (IOException e) {
            LOG.error("Unable to load resource: " + url, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Collection<String> getBlackList() {
        Object object = BLACK_LIST_LOCK;
        synchronized (object) {
            if (ourBlackList == null) {
                InspectionProfileEntry.loadBlackList();
            }
            return ourBlackList;
        }
    }

    @Nullable
    protected SerializationFilter getSerializationFilter() {
        return DEFAULT_FILTER;
    }

    public void projectOpened(@NotNull Project project) {
    }

    public void projectClosed(@NotNull Project project) {
    }

    @Nullable
    public String getStaticDescription() {
        return null;
    }

    @Nullable
    public String getDescriptionFileName() {
        return null;
    }

    @Nullable
    protected URL getDescriptionUrl() {
        String fileName = this.getDescriptionFileName();
        if (fileName == null) {
            return null;
        }
        return ResourceUtil.getResource(this.getDescriptionContextClass(), (String)"/inspectionDescriptions", (String)fileName);
    }

    @NotNull
    protected Class<? extends InspectionProfileEntry> getDescriptionContextClass() {
        return this.getClass();
    }

    public boolean isInitialized() {
        return true;
    }

    @Nullable
    public String getMainToolId() {
        return null;
    }

    @Nullable
    public String loadDescription() {
        String description = this.getStaticDescription();
        if (description != null) {
            return description;
        }
        try {
            URL descriptionUrl = this.getDescriptionUrl();
            if (descriptionUrl == null) {
                return null;
            }
            return ResourceUtil.loadText((URL)descriptionUrl);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static {
        BLACK_LIST_LOCK = new Object();
    }

    static interface DefaultNameProvider {
        @Nullable
        public String getDefaultShortName();

        @Nullable
        public String getDefaultDisplayName();

        @Nullable
        public String getDefaultGroupDisplayName();
    }
}

