/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.util.PsiUtilCore;
import gnu.trove.THashSet;
import java.awt.Color;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LookupElementBuilder
extends LookupElement {
    @NotNull
    private final String myLookupString;
    @NotNull
    private final Object myObject;
    private final boolean myCaseSensitive;
    @Nullable
    private final InsertHandler<LookupElement> myInsertHandler;
    @Nullable
    private final LookupElementRenderer<LookupElement> myRenderer;
    @Nullable
    private final LookupElementPresentation myHardcodedPresentation;
    @NotNull
    private final Set<String> myAllLookupStrings;

    private LookupElementBuilder(@NotNull String lookupString, @NotNull Object object, @Nullable InsertHandler<LookupElement> insertHandler, @Nullable LookupElementRenderer<LookupElement> renderer, @Nullable LookupElementPresentation hardcodedPresentation, @NotNull Set<String> allLookupStrings, boolean caseSensitive) {
        this.myLookupString = lookupString;
        this.myObject = object;
        this.myInsertHandler = insertHandler;
        this.myRenderer = renderer;
        this.myHardcodedPresentation = hardcodedPresentation;
        this.myAllLookupStrings = Collections.unmodifiableSet(allLookupStrings);
        this.myCaseSensitive = caseSensitive;
    }

    private LookupElementBuilder(@NotNull String lookupString, @NotNull Object object) {
        this(lookupString, object, null, null, null, Collections.singleton(lookupString), true);
    }

    @NotNull
    public static LookupElementBuilder create(@NotNull String lookupString) {
        return new LookupElementBuilder(lookupString, lookupString);
    }

    public static LookupElementBuilder create(@NotNull Object object) {
        return new LookupElementBuilder(object.toString(), object);
    }

    public static LookupElementBuilder createWithSmartPointer(@NotNull String lookupString, @NotNull PsiElement element) {
        PsiUtilCore.ensureValid(element);
        return new LookupElementBuilder(lookupString, SmartPointerManager.getInstance(element.getProject()).createSmartPsiElementPointer(element));
    }

    public static LookupElementBuilder create(@NotNull PsiNamedElement element) {
        PsiUtilCore.ensureValid(element);
        return new LookupElementBuilder(StringUtil.notNullize((String)element.getName()), element);
    }

    public static LookupElementBuilder createWithIcon(@NotNull PsiNamedElement element) {
        PsiUtilCore.ensureValid(element);
        return LookupElementBuilder.create(element).withIcon(element.getIcon(0));
    }

    public static LookupElementBuilder create(@NotNull Object lookupObject, @NotNull String lookupString) {
        if (lookupObject instanceof PsiElement) {
            PsiUtilCore.ensureValid((PsiElement)lookupObject);
        }
        return new LookupElementBuilder(lookupString, lookupObject);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder setInsertHandler(@Nullable InsertHandler<LookupElement> insertHandler) {
        return this.withInsertHandler(insertHandler);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder withInsertHandler(@Nullable InsertHandler<LookupElement> insertHandler) {
        return new LookupElementBuilder(this.myLookupString, this.myObject, insertHandler, this.myRenderer, this.myHardcodedPresentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder setRenderer(@Nullable LookupElementRenderer<LookupElement> renderer) {
        return this.withRenderer(renderer);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder withRenderer(@Nullable LookupElementRenderer<LookupElement> renderer) {
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, renderer, this.myHardcodedPresentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Override
    @NotNull
    public Set<String> getAllLookupStrings() {
        return this.myAllLookupStrings;
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder setIcon(@Nullable Icon icon) {
        return this.withIcon(icon);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder withIcon(@Nullable Icon icon) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setIcon(icon);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @NotNull
    private LookupElementPresentation copyPresentation() {
        LookupElementPresentation presentation = new LookupElementPresentation();
        if (this.myHardcodedPresentation != null) {
            presentation.copyFrom(this.myHardcodedPresentation);
        } else {
            presentation.setItemText(this.myLookupString);
        }
        return presentation;
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder addLookupString(@NotNull String another) {
        return this.withLookupString(another);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder withLookupString(@NotNull String another) {
        THashSet set = new THashSet(this.myAllLookupStrings);
        set.add((Object)another);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, this.myRenderer, this.myHardcodedPresentation, Collections.unmodifiableSet(set), this.myCaseSensitive);
    }

    @Override
    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder setCaseSensitive(boolean caseSensitive) {
        return this.withCaseSensitivity(caseSensitive);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder withCaseSensitivity(boolean caseSensitive) {
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, this.myRenderer, this.myHardcodedPresentation, this.myAllLookupStrings, caseSensitive);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder setItemTextForeground(@NotNull Color itemTextForeground) {
        return this.withItemTextForeground(itemTextForeground);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder withItemTextForeground(@NotNull Color itemTextForeground) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setItemTextForeground(itemTextForeground);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder setItemTextUnderlined(boolean underlined) {
        return this.withItemTextUnderlined(underlined);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder withItemTextUnderlined(boolean underlined) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setItemTextUnderlined(underlined);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder setTypeText(@Nullable String typeText) {
        return this.withTypeText(typeText);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder withTypeText(@Nullable String typeText) {
        return this.withTypeText(typeText, false);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder setTypeText(@Nullable String typeText, boolean grayed) {
        return this.withTypeText(typeText, grayed);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder withTypeText(@Nullable String typeText, boolean grayed) {
        return this.withTypeText(typeText, null, grayed);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder withTypeText(@Nullable String typeText, @Nullable Icon typeIcon, boolean grayed) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setTypeText(typeText, typeIcon);
        presentation.setTypeGrayed(grayed);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder setPresentableText(@NotNull String presentableText) {
        return this.withPresentableText(presentableText);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder withPresentableText(@NotNull String presentableText) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setItemText(presentableText);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder setBold() {
        return this.bold();
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder bold() {
        return this.withBoldness(true);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder setBold(boolean bold) {
        return this.withBoldness(bold);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder withBoldness(boolean bold) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setItemTextBold(bold);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder setStrikeout() {
        return this.strikeout();
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder strikeout() {
        return this.withStrikeoutness(true);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder setStrikeout(boolean strikeout) {
        return this.withStrikeoutness(strikeout);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder withStrikeoutness(boolean strikeout) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setStrikeout(strikeout);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder setTailText(@Nullable String tailText) {
        return this.withTailText(tailText);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder withTailText(@Nullable String tailText) {
        return this.withTailText(tailText, false);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder setTailText(@Nullable String tailText, boolean grayed) {
        return this.withTailText(tailText, grayed);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder withTailText(@Nullable String tailText, boolean grayed) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setTailText(tailText, grayed);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(value="", pure=true)
    public LookupElementBuilder appendTailText(@NotNull String tailText, boolean grayed) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.appendTailText(tailText, grayed);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(value="", pure=true)
    public LookupElement withAutoCompletionPolicy(AutoCompletionPolicy policy) {
        return policy.applyPolicy(this);
    }

    @Override
    @NotNull
    public String getLookupString() {
        return this.myLookupString;
    }

    @Override
    @NotNull
    public Object getObject() {
        return this.myObject;
    }

    @Override
    public void handleInsert(InsertionContext context) {
        if (this.myInsertHandler != null) {
            this.myInsertHandler.handleInsert(context, this);
        }
    }

    @Override
    public void renderElement(LookupElementPresentation presentation) {
        if (this.myRenderer != null) {
            this.myRenderer.renderElement(this, presentation);
        } else if (this.myHardcodedPresentation != null) {
            presentation.copyFrom(this.myHardcodedPresentation);
        } else {
            presentation.setItemText(this.myLookupString);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LookupElementBuilder that = (LookupElementBuilder)((Object)o);
        InsertHandler<LookupElement> insertHandler = that.myInsertHandler;
        if (this.myInsertHandler != null && insertHandler != null ? !this.myInsertHandler.getClass().equals(insertHandler.getClass()) : this.myInsertHandler != insertHandler) {
            return false;
        }
        if (!this.myLookupString.equals(that.myLookupString)) {
            return false;
        }
        if (!this.myObject.equals(that.myObject)) {
            return false;
        }
        LookupElementRenderer<LookupElement> renderer = that.myRenderer;
        return !(this.myRenderer != null && renderer != null ? !this.myRenderer.getClass().equals(renderer.getClass()) : this.myRenderer != renderer);
    }

    @Override
    public String toString() {
        return "LookupElementBuilder: string=" + this.getLookupString() + "; handler=" + this.myInsertHandler;
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.myInsertHandler != null ? this.myInsertHandler.getClass().hashCode() : 0);
        result = 31 * result + this.myLookupString.hashCode();
        result = 31 * result + this.myObject.hashCode();
        result = 31 * result + (this.myRenderer != null ? this.myRenderer.getClass().hashCode() : 0);
        return result;
    }
}

