/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.moveUpDown;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LineRange {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.actions.moveUpDown.LineRange");
    public final int startLine;
    public final int endLine;
    public PsiElement firstElement;
    public PsiElement lastElement;

    public LineRange(int startLine, int endLine) {
        this.startLine = startLine;
        this.endLine = endLine;
        LOG.assertTrue(startLine >= 0, (Object)"Negative start line");
        if (startLine > endLine) {
            LOG.error("start > end: start=" + startLine + "; end=" + endLine);
        }
    }

    public LineRange(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull Document document) {
        this(document.getLineNumber(startElement.getTextRange().getStartOffset()), document.getLineNumber(endElement.getTextRange().getEndOffset()) + 1);
    }

    public LineRange(@NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        this(startElement, endElement, startElement.getContainingFile().getViewProvider().getDocument());
    }

    public LineRange(@NotNull PsiElement element) {
        this(element, element);
    }

    @NonNls
    public String toString() {
        return "line range: [" + this.startLine + "-" + this.endLine + "]";
    }

    public boolean containsLine(int lineNumber) {
        return this.startLine <= lineNumber && this.endLine > lineNumber;
    }

    public boolean contains(LineRange range) {
        return this.startLine <= range.startLine && this.endLine >= range.endLine;
    }
}

