/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DaemonCodeAnalyzer {
    public static final Topic<DaemonListener> DAEMON_EVENT_TOPIC = Topic.create((String)"DAEMON_EVENT_TOPIC", DaemonListener.class);

    public static DaemonCodeAnalyzer getInstance(Project project) {
        return project.getComponent(DaemonCodeAnalyzer.class);
    }

    public abstract void settingsChanged();

    @Deprecated
    public abstract void updateVisibleHighlighters(@NotNull Editor var1);

    public abstract void setUpdateByTimerEnabled(boolean var1);

    public abstract void disableUpdateByTimer(@NotNull Disposable var1);

    public abstract boolean isHighlightingAvailable(@Nullable PsiFile var1);

    public abstract void setImportHintsEnabled(@NotNull PsiFile var1, boolean var2);

    public abstract void resetImportHintsEnabledForProject();

    public abstract void setHighlightingEnabled(@NotNull PsiFile var1, boolean var2);

    public abstract boolean isImportHintsEnabled(@NotNull PsiFile var1);

    public abstract boolean isAutohintsAvailable(@Nullable PsiFile var1);

    public abstract void restart();

    public abstract void restart(@NotNull PsiFile var1);

    public abstract void autoImportReferenceAtCursor(@NotNull Editor var1, @NotNull PsiFile var2);

    public static abstract class DaemonListenerAdapter
    implements DaemonListener {
        @Override
        public void daemonFinished() {
        }

        @Override
        public void daemonCancelEventOccurred(@NotNull String reason) {
        }
    }

    public static interface DaemonListener {
        public void daemonFinished();

        public void daemonCancelEventOccurred(@NotNull String var1);
    }
}

