/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightTestData;
import com.intellij.codeInsight.EditorInfo;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.ProjectScope;
import com.intellij.testFramework.EditorTestUtil;
import com.intellij.testFramework.LightPlatformCodeInsightTestCase;
import com.intellij.testFramework.PsiTestCase;
import com.intellij.testFramework.PsiTestData;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeInsightTestCase
extends PsiTestCase {
    protected Editor myEditor;

    protected Editor createEditor(@NotNull VirtualFile file) {
        FileEditorManager instance = FileEditorManager.getInstance(this.myProject);
        if (file.getFileType().isBinary()) {
            return null;
        }
        PsiDocumentManager.getInstance(this.getProject()).commitAllDocuments();
        Editor editor = instance.openTextEditor(new OpenFileDescriptor(this.myProject, file, 0), false);
        ((EditorImpl)editor).setCaretActive();
        PsiDocumentManager.getInstance(this.getProject()).commitAllDocuments();
        DaemonCodeAnalyzer.getInstance(this.getProject()).restart();
        return editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            if (this.myProject != null) {
                VirtualFile[] openFiles;
                FileEditorManager editorManager = FileEditorManager.getInstance(this.myProject);
                for (VirtualFile openFile : openFiles = editorManager.getOpenFiles()) {
                    editorManager.closeFile(openFile);
                }
            }
        }
        finally {
            this.myEditor = null;
            super.tearDown();
        }
    }

    @Override
    protected PsiTestData createData() {
        return new CodeInsightTestData();
    }

    protected void configureByFile(String filePath2) throws Exception {
        this.configureByFile(filePath2, null);
    }

    protected VirtualFile configureByFiles(@Nullable String projectRoot, String ... files) throws Exception {
        if (files.length == 0) {
            return null;
        }
        VirtualFile[] vFiles = new VirtualFile[files.length];
        for (int i = 0; i < files.length; ++i) {
            vFiles[i] = this.findVirtualFile(files[i]);
        }
        File projectFile = projectRoot == null ? null : new File(this.getTestDataPath() + projectRoot);
        return this.configureByFiles(projectFile, vFiles);
    }

    private void allowRootAccess(String filePath2) {
        VfsRootAccess.allowRootAccess((Disposable)this.myTestRootDisposable, (String[])new String[]{filePath2});
    }

    protected VirtualFile configureByFile(String filePath2, @Nullable String projectRoot) throws Exception {
        VirtualFile vFile = this.findVirtualFile(filePath2);
        File projectFile = projectRoot == null ? null : new File(this.getTestDataPath() + projectRoot);
        return this.configureByFile(vFile, projectFile);
    }

    protected PsiFile configureByText(@NotNull FileType fileType, @NotNull String text) {
        return this.configureByText(fileType, text, null);
    }

    protected PsiFile configureByText(final @NotNull FileType fileType, final @NotNull String text, @Nullable String _extension) {
        try {
            final String extension = _extension == null ? fileType.getDefaultExtension() : _extension;
            File dir = this.createTempDirectory();
            File tempFile = FileUtil.createTempFile((File)dir, (String)"tempFile", (String)("." + extension), (boolean)true);
            final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
            if (fileTypeManager.getFileTypeByExtension(extension) != fileType) {
                new WriteCommandAction(this.getProject(), new PsiFile[0]){

                    @Override
                    protected void run(@NotNull Result result) throws Exception {
                        fileTypeManager.associateExtension(fileType, extension);
                    }
                }.execute();
            }
            final VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempFile);
            assert (vFile != null);
            new WriteAction(){

                @Override
                protected void run(@NotNull Result result) throws Throwable {
                    vFile.setCharset(CharsetToolkit.UTF8_CHARSET);
                    VfsUtil.saveText(vFile, text);
                }
            }.execute();
            VirtualFile vdir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(dir);
            PsiTestUtil.addSourceRoot((Module)this.myModule, (VirtualFile)vdir);
            this.configureByExistingFile(vFile);
            CodeInsightTestCase.assertEquals((Object)fileType, (Object)this.myFile.getVirtualFile().getFileType());
            return this.myFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void configureByFile(@NotNull VirtualFile vFile) throws IOException {
        this.configureByFile(vFile, null);
    }

    protected void configureByExistingFile(final @NotNull VirtualFile virtualFile) {
        this.myFile = null;
        this.myEditor = null;
        final Editor editor = this.createEditor(virtualFile);
        final Document document = editor.getDocument();
        final EditorInfo editorInfo = new EditorInfo(document.getText());
        final String newFileText = editorInfo.getNewFileText();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                if (!document.getText().equals(newFileText)) {
                    document.setText(newFileText);
                }
                PsiFile file = CodeInsightTestCase.this.myPsiManager.findFile(virtualFile);
                if (CodeInsightTestCase.this.myFile == null) {
                    CodeInsightTestCase.this.myFile = file;
                }
                if (CodeInsightTestCase.this.myEditor == null) {
                    CodeInsightTestCase.this.myEditor = editor;
                }
                editorInfo.applyToEditor(editor);
            }
        });
        PsiDocumentManager.getInstance(this.getProject()).commitAllDocuments();
    }

    protected VirtualFile configureByFiles(final @Nullable File rawProjectRoot, final VirtualFile ... vFiles) throws IOException {
        this.myFile = null;
        this.myEditor = null;
        final File toDirIO = this.createTempDirectory();
        final VirtualFile toDir = CodeInsightTestCase.getVirtualFile((File)toDirIO);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    LinkedHashMap<VirtualFile, EditorInfo> editorInfos;
                    ModuleRootManager rootManager = ModuleRootManager.getInstance(CodeInsightTestCase.this.myModule);
                    ModifiableRootModel rootModel = rootManager.getModifiableModel();
                    if (CodeInsightTestCase.this.clearModelBeforeConfiguring()) {
                        rootModel.clear();
                    }
                    Object[] reversed = (VirtualFile[])ArrayUtil.reverseArray((Object[])vFiles);
                    if (rawProjectRoot != null) {
                        Object[] projectRoot = rawProjectRoot.getCanonicalFile();
                        FileUtil.copyDir((File)projectRoot, (File)toDirIO);
                        VirtualFile fromDir = CodeInsightTestCase.getVirtualFile((File)((File)projectRoot));
                        editorInfos = CodeInsightTestCase.this.copyFilesFillingEditorInfos(fromDir, toDir, (String[])ContainerUtil.map2Array((Object[])reversed, String.class, (Function)new Function<VirtualFile, String>((File)projectRoot){
                            final /* synthetic */ File val$projectRoot;
                            {
                                this.val$projectRoot = file;
                            }

                            public String fun(VirtualFile s) {
                                return s.getPath().substring(this.val$projectRoot.getPath().length());
                            }
                        }));
                        toDir.refresh(false, true);
                    } else {
                        editorInfos = new LinkedHashMap<VirtualFile, EditorInfo>();
                        for (VirtualFile virtualFile : reversed) {
                            VirtualFile parent = virtualFile.getParent();
                            assert (parent.isDirectory()) : parent;
                            editorInfos.putAll(CodeInsightTestCase.this.copyFilesFillingEditorInfos(parent, toDir, virtualFile.getName()));
                        }
                    }
                    boolean sourceRootAdded = false;
                    if (CodeInsightTestCase.this.isAddDirToContentRoot()) {
                        ContentEntry contentEntry = rootModel.addContentEntry(toDir);
                        if (CodeInsightTestCase.this.isAddDirToSource()) {
                            sourceRootAdded = true;
                            contentEntry.addSourceFolder(toDir, CodeInsightTestCase.this.isAddDirToTests());
                        }
                    }
                    CodeInsightTestCase.this.doCommitModel(rootModel);
                    if (sourceRootAdded) {
                        CodeInsightTestCase.this.sourceRootAdded(toDir);
                    }
                    CodeInsightTestCase.this.openEditorsAndActivateLast(editorInfos);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
        return toDir;
    }

    protected boolean isAddDirToTests() {
        return false;
    }

    protected void doCommitModel(@NotNull ModifiableRootModel rootModel) {
        rootModel.commit();
    }

    protected void sourceRootAdded(VirtualFile dir) {
    }

    @NotNull
    protected Map<VirtualFile, EditorInfo> copyFilesFillingEditorInfos(@NotNull String testDataFromDir, @NotNull VirtualFile toDir, String ... relativePaths) throws IOException {
        if (!testDataFromDir.startsWith("/")) {
            testDataFromDir = "/" + testDataFromDir;
        }
        return this.copyFilesFillingEditorInfos(LocalFileSystem.getInstance().refreshAndFindFileByPath(this.getTestDataPath() + testDataFromDir), toDir, relativePaths);
    }

    @NotNull
    protected Map<VirtualFile, EditorInfo> copyFilesFillingEditorInfos(@NotNull VirtualFile fromDir, @NotNull VirtualFile toDir, String ... relativePaths) throws IOException {
        LinkedHashMap<VirtualFile, EditorInfo> editorInfos = new LinkedHashMap<VirtualFile, EditorInfo>();
        ArrayList<OutputStream> streamsToClose = new ArrayList<OutputStream>();
        for (String relativePath : relativePaths) {
            relativePath = StringUtil.trimStart((String)relativePath, (String)"/");
            VirtualFile fromFile = fromDir.findFileByRelativePath(relativePath);
            CodeInsightTestCase.assertNotNull((String)(fromDir.getPath() + "/" + relativePath), (Object)fromFile);
            VirtualFile toFile = toDir.findFileByRelativePath(relativePath);
            if (toFile == null) {
                File file = new File(toDir.getPath(), relativePath);
                FileUtil.createIfDoesntExist((File)file);
                toFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
                CodeInsightTestCase.assertNotNull((String)file.getCanonicalPath(), (Object)toFile);
            }
            toFile.putUserData(VfsTestUtil.TEST_DATA_FILE_PATH, FileUtil.toSystemDependentName((String)fromFile.getPath()));
            editorInfos.put(toFile, this.copyContent(fromFile, toFile, streamsToClose));
        }
        for (int i = streamsToClose.size() - 1; i >= 0; --i) {
            ((OutputStream)streamsToClose.get(i)).close();
        }
        return editorInfos;
    }

    private EditorInfo copyContent(@NotNull VirtualFile from, @NotNull VirtualFile to, @NotNull List<OutputStream> streamsToClose) throws IOException {
        byte[] content = from.getFileType().isBinary() ? from.contentsToByteArray() : null;
        String fileText = from.getFileType().isBinary() ? null : StringUtil.convertLineSeparators((String)VfsUtilCore.loadText(from));
        EditorInfo editorInfo = fileText == null ? null : new EditorInfo(fileText);
        String newFileText = fileText == null ? null : editorInfo.getNewFileText();
        this.doWrite(newFileText, to, content, streamsToClose);
        return editorInfo;
    }

    protected final void setActiveEditor(@NotNull Editor editor) {
        this.myEditor = editor;
        this.myFile = this.getPsiFile(editor.getDocument());
    }

    @NotNull
    protected List<Editor> openEditorsAndActivateLast(@NotNull Map<VirtualFile, EditorInfo> editorInfos) {
        List<Editor> list = this.openEditors(editorInfos);
        this.setActiveEditor(list.get(list.size() - 1));
        return list;
    }

    @NotNull
    protected final List<Editor> openEditors(final @NotNull Map<VirtualFile, EditorInfo> editorInfos) {
        return ContainerUtil.map(editorInfos.keySet(), (Function)new Function<VirtualFile, Editor>(){

            public Editor fun(VirtualFile newVFile) {
                EditorInfo editorInfo;
                PsiFile file = CodeInsightTestCase.this.myPsiManager.findFile(newVFile);
                if (CodeInsightTestCase.this.myFile == null) {
                    CodeInsightTestCase.this.myFile = file;
                }
                Editor editor = CodeInsightTestCase.this.createEditor(newVFile);
                if (CodeInsightTestCase.this.myEditor == null) {
                    CodeInsightTestCase.this.myEditor = editor;
                }
                if ((editorInfo = (EditorInfo)editorInfos.get(newVFile)) != null) {
                    editorInfo.applyToEditor(editor);
                }
                return editor;
            }
        });
    }

    private void doWrite(String newFileText, @NotNull VirtualFile newVFile, byte[] content, @NotNull List<OutputStream> streamsToClose) throws IOException {
        if (newFileText == null) {
            OutputStream outputStream = newVFile.getOutputStream((Object)this, -1L, -1L);
            outputStream.write(content);
            streamsToClose.add(outputStream);
        } else {
            CodeInsightTestCase.setFileText((VirtualFile)newVFile, (String)newFileText);
        }
    }

    protected boolean isAddDirToContentRoot() {
        return true;
    }

    protected boolean isAddDirToSource() {
        return true;
    }

    protected VirtualFile configureByFile(@NotNull VirtualFile vFile, File projectRoot) throws IOException {
        return this.configureByFiles(projectRoot, vFile);
    }

    protected boolean clearModelBeforeConfiguring() {
        return false;
    }

    protected void setupCursorAndSelection(@NotNull Editor editor) {
        Document document = editor.getDocument();
        EditorTestUtil.CaretAndSelectionState caretState = EditorTestUtil.extractCaretAndSelectionMarkers((Document)document);
        EditorTestUtil.setCaretsAndSelection((Editor)editor, (EditorTestUtil.CaretAndSelectionState)caretState);
        PsiDocumentManager.getInstance(this.myProject).commitAllDocuments();
    }

    @Override
    protected void configure(@NotNull String path2, String dataName) throws Exception {
        int selectionEnd;
        super.configure(path2, dataName);
        this.myEditor = this.createEditor(this.myFile.getVirtualFile());
        CodeInsightTestData data = (CodeInsightTestData)this.myTestDataBefore;
        LogicalPosition pos = new LogicalPosition(data.getLineNumber() - 1, data.getColumnNumber() - 1);
        this.myEditor.getCaretModel().moveToLogicalPosition(pos);
        int selectionStart = selectionEnd = this.myEditor.getCaretModel().getOffset();
        if (data.getSelectionStartColumnNumber() >= 0) {
            selectionStart = this.myEditor.logicalPositionToOffset(new LogicalPosition(data.getSelectionEndLineNumber() - 1, data.getSelectionStartColumnNumber() - 1));
            selectionEnd = this.myEditor.logicalPositionToOffset(new LogicalPosition(data.getSelectionEndLineNumber() - 1, data.getSelectionEndColumnNumber() - 1));
        }
        this.myEditor.getSelectionModel().setSelection(selectionStart, selectionEnd);
    }

    protected void checkResultByFile(@NotNull String filePath2) throws Exception {
        this.checkResultByFile(filePath2, false);
    }

    protected void checkResultByFile(final @NotNull String filePath2, final boolean stripTrailingSpaces) throws Exception {
        new WriteCommandAction<Document>(this.getProject(), new PsiFile[0]){

            @Override
            protected void run(@NotNull Result<Document> result) throws Throwable {
                String newFileText;
                String ft;
                this.getProject().getComponent(PostprocessReformattingAspect.class).doPostponedFormatting();
                if (stripTrailingSpaces) {
                    ((DocumentImpl)CodeInsightTestCase.this.myEditor.getDocument()).stripTrailingSpaces(this.getProject());
                }
                PsiDocumentManager.getInstance(CodeInsightTestCase.this.myProject).commitAllDocuments();
                VirtualFile vFile = CodeInsightTestCase.this.findVirtualFile(filePath2);
                try {
                    ft = VfsUtilCore.loadText(vFile);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                String fileText = StringUtil.convertLineSeparators((String)ft);
                Document document = EditorFactory.getInstance().createDocument(fileText);
                EditorTestUtil.CaretAndSelectionState caretState = EditorTestUtil.extractCaretAndSelectionMarkers((Document)document);
                String newFileText1 = newFileText = document.getText();
                if (stripTrailingSpaces) {
                    Document document1 = EditorFactory.getInstance().createDocument(newFileText);
                    ((DocumentImpl)document1).stripTrailingSpaces(this.getProject());
                    newFileText1 = document1.getText();
                }
                if (CodeInsightTestCase.this.myEditor instanceof EditorWindow) {
                    CodeInsightTestCase.this.myEditor = ((EditorWindow)CodeInsightTestCase.this.myEditor).getDelegate();
                }
                CodeInsightTestCase.this.myFile = PsiDocumentManager.getInstance(this.getProject()).getPsiFile(CodeInsightTestCase.this.myEditor.getDocument());
                String text = CodeInsightTestCase.this.myFile.getText();
                text = StringUtil.convertLineSeparators((String)text);
                TestCase.assertEquals((String)("Text mismatch in file " + filePath2), (String)newFileText1, (String)text);
                EditorTestUtil.verifyCaretAndSelectionState((Editor)CodeInsightTestCase.this.myEditor, (EditorTestUtil.CaretAndSelectionState)caretState);
            }
        }.execute();
    }

    @Override
    protected void checkResult(String dataName) throws Exception {
        PsiDocumentManager.getInstance(this.myProject).commitAllDocuments();
        super.checkResult(dataName);
        CodeInsightTestData data = (CodeInsightTestData)this.myTestDataAfter;
        if (data.getColumnNumber() >= 0) {
            CodeInsightTestCase.assertEquals((String)(dataName + ":caretColumn"), (int)data.getColumnNumber(), (int)(this.myEditor.getCaretModel().getLogicalPosition().column + 1));
        }
        if (data.getLineNumber() >= 0) {
            CodeInsightTestCase.assertEquals((String)(dataName + ":caretLine"), (int)data.getLineNumber(), (int)(this.myEditor.getCaretModel().getLogicalPosition().line + 1));
        }
        int selectionStart = this.myEditor.getSelectionModel().getSelectionStart();
        int selectionEnd = this.myEditor.getSelectionModel().getSelectionEnd();
        LogicalPosition startPosition = this.myEditor.offsetToLogicalPosition(selectionStart);
        LogicalPosition endPosition = this.myEditor.offsetToLogicalPosition(selectionEnd);
        if (data.getSelectionStartColumnNumber() >= 0) {
            CodeInsightTestCase.assertEquals((String)(dataName + ":selectionStartColumn"), (int)data.getSelectionStartColumnNumber(), (int)(startPosition.column + 1));
        }
        if (data.getSelectionStartLineNumber() >= 0) {
            CodeInsightTestCase.assertEquals((String)(dataName + ":selectionStartLine"), (int)data.getSelectionStartLineNumber(), (int)(startPosition.line + 1));
        }
        if (data.getSelectionEndColumnNumber() >= 0) {
            CodeInsightTestCase.assertEquals((String)(dataName + ":selectionEndColumn"), (int)data.getSelectionEndColumnNumber(), (int)(endPosition.column + 1));
        }
        if (data.getSelectionEndLineNumber() >= 0) {
            CodeInsightTestCase.assertEquals((String)(dataName + ":selectionEndLine"), (int)data.getSelectionEndLineNumber(), (int)(endPosition.line + 1));
        }
    }

    @NotNull
    protected VirtualFile getVirtualFile(@NotNull String filePath2) {
        return this.findVirtualFile(filePath2);
    }

    @NotNull
    private VirtualFile findVirtualFile(@NotNull String filePath2) {
        String absolutePath = this.getTestDataPath() + filePath2;
        this.allowRootAccess(absolutePath);
        return VfsTestUtil.findFileByCaseSensitivePath((String)absolutePath);
    }

    @NotNull
    protected String getTestRoot() {
        return FileUtil.toSystemIndependentName((String)this.getTestDataPath());
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    protected void type(char c) {
        LightPlatformCodeInsightTestCase.type((char)c, (Editor)this.getEditor(), (Project)this.getProject());
    }

    protected void undo() {
        UndoManager undoManager = UndoManager.getInstance(this.myProject);
        TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(this.getEditor());
        undoManager.undo(textEditor);
    }

    protected void caretLeft() {
        this.caretLeft(this.getEditor());
    }

    protected void caretLeft(@NotNull Editor editor) {
        LightPlatformCodeInsightTestCase.executeAction((String)"EditorLeft", (Editor)editor, (Project)this.getProject());
    }

    protected void caretRight() {
        this.caretRight(this.getEditor());
    }

    protected void caretRight(@NotNull Editor editor) {
        LightPlatformCodeInsightTestCase.executeAction((String)"EditorRight", (Editor)editor, (Project)this.getProject());
    }

    protected void caretUp() {
        LightPlatformCodeInsightTestCase.executeAction((String)"EditorUp", (Editor)this.myEditor, (Project)this.getProject());
    }

    protected void deleteLine() {
        LightPlatformCodeInsightTestCase.deleteLine((Editor)this.myEditor, (Project)this.getProject());
    }

    protected void type(@NotNull String s) {
        for (char c : s.toCharArray()) {
            this.type(c);
        }
    }

    protected void backspace() {
        this.backspace(this.getEditor());
    }

    protected void backspace(@NotNull Editor editor) {
        LightPlatformCodeInsightTestCase.backspace((Editor)editor, (Project)this.getProject());
    }

    protected void ctrlW() {
        LightPlatformCodeInsightTestCase.ctrlW((Editor)this.getEditor(), (Project)this.getProject());
    }

    protected void ctrlD() {
        LightPlatformCodeInsightTestCase.ctrlD((Editor)this.getEditor(), (Project)this.getProject());
    }

    protected void delete(@NotNull Editor editor) {
        LightPlatformCodeInsightTestCase.delete((Editor)editor, (Project)this.getProject());
    }

    @NotNull
    protected PsiClass findClass(@NotNull String name) {
        PsiClass aClass = this.myJavaFacade.findClass(name, ProjectScope.getProjectScope(this.getProject()));
        CodeInsightTestCase.assertNotNull((String)("Class " + name + " not found"), (Object)aClass);
        return aClass;
    }

    @NotNull
    protected PsiPackage findPackage(@NotNull String name) {
        PsiPackage aPackage = this.myJavaFacade.findPackage(name);
        CodeInsightTestCase.assertNotNull((String)("Package " + name + " not found"), (Object)aPackage);
        return aPackage;
    }
}

