/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiNameValuePair;
import java.lang.annotation.Annotation;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

class AnnotationInvocationHandler
implements InvocationHandler {
    @NotNull
    private final Class<? extends Annotation> type;
    @NotNull
    private final PsiAnnotation myAnnotation;

    AnnotationInvocationHandler(@NotNull Class<? extends Annotation> type, @NotNull PsiAnnotation annotation) {
        this.type = type;
        this.myAnnotation = annotation;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        Object[] paramTypes = method.getParameterTypes();
        assert (paramTypes.length == 0) : Arrays.toString(paramTypes);
        String member = method.getName();
        if (member.equals("toString")) {
            return this.toStringImpl();
        }
        if (member.equals("annotationType")) {
            return this.type;
        }
        PsiAnnotationMemberValue value = this.myAnnotation.findAttributeValue(member);
        if (value == null) {
            throw new IncompleteAnnotationException(this.type, member + ". (Unable to find attribute in '" + this.myAnnotation.getText() + "')");
        }
        Object result = JavaPsiFacade.getInstance(this.myAnnotation.getProject()).getConstantEvaluationHelper().computeConstantExpression(value);
        if (result == null) {
            throw new IncompleteAnnotationException(this.type, member + ". (Unable to evaluate annotation value '" + value + "')");
        }
        return result;
    }

    private String toStringImpl() {
        PsiNameValuePair[] attributes;
        StringBuilder result = new StringBuilder(128);
        result.append('@');
        result.append(this.type.getName());
        result.append('(');
        boolean firstMember = true;
        for (PsiNameValuePair e : attributes = this.myAnnotation.getParameterList().getAttributes()) {
            if (firstMember) {
                firstMember = false;
            } else {
                result.append(", ");
            }
            result.append(e.getName());
            result.append('=');
            PsiAnnotationMemberValue value = e.getValue();
            result.append(value == null ? "null" : value.getText());
        }
        result.append(')');
        return result.toString();
    }
}

