/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.samples;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.ui.properties.core.OptionalProperty;
import com.android.tools.idea.ui.properties.core.OptionalValueProperty;
import com.android.tools.idea.wizard.model.WizardModel;
import com.appspot.gsamplesindex.samplesindex.model.Sample;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.gct.login.stats.UsageTrackerService;
import com.google.gct.studio.samples.GithubRepoContents;
import com.google.gct.studio.util.GctStudioBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SampleModel
extends WizardModel {
    private final OptionalProperty<Sample> mySample = new OptionalValueProperty();
    private final OptionalProperty<String> myProjectName = new OptionalValueProperty();
    private final OptionalProperty<File> myDir = new OptionalValueProperty();

    @NotNull
    public static String trimSlashes(@NotNull String path) {
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        while (path.startsWith("/")) {
            path = path.substring(1, path.length());
        }
        return path;
    }

    private static Logger getLog() {
        return Logger.getInstance(SampleModel.class);
    }

    public OptionalProperty<Sample> sample() {
        return this.mySample;
    }

    public OptionalProperty<String> projectName() {
        return this.myProjectName;
    }

    public OptionalProperty<File> dir() {
        return this.myDir;
    }

    protected void handleFinished() {
        String basePath;
        Project project;
        String projectName;
        block16: {
            if (!(((Optional)this.mySample.get()).isPresent() && ((Optional)this.myDir.get()).isPresent() && ((Optional)this.myProjectName.get()).isPresent())) {
                SampleModel.getLog().error("SampleImportWizard did not collect expected information and will not complete. Please report this error.");
                return;
            }
            Sample sample = (Sample)this.mySample.getValue();
            File dir = (File)this.myDir.getValue();
            projectName = (String)this.myProjectName.getValue();
            if (!FileUtilRt.createDirectory((File)dir)) {
                Messages.showErrorDialog((String)GctStudioBundle.message("create.project.dir.failed", new Object[0]), (String)GctStudioBundle.message("sample.import.error.title", new Object[0]));
                return;
            }
            project = ProjectManager.getInstance().createProject(projectName, dir.getAbsolutePath());
            assert (project != null);
            String url = SampleModel.trimSlashes(sample.getCloneUrl());
            GithubRepoContents downloadResult = GithubRepoContents.download(project, url, null, null);
            if (downloadResult.isCancelled()) {
                SampleModel.getLog().info("Sample download cancelled by user");
                return;
            }
            String errorMessage = downloadResult.getErrorMessage();
            if (errorMessage != null) {
                SampleModel.getLog().warn(errorMessage);
                Messages.showErrorDialog((String)errorMessage, (String)GctStudioBundle.message("sample.import.error.title", new Object[0]));
                return;
            }
            List<File> sampleRoots = downloadResult.getSampleRoots();
            if (sampleRoots.size() == 0) {
                Messages.showErrorDialog((String)GctStudioBundle.message("git.project.dir.empty", new Object[0]), (String)GctStudioBundle.message("sample.import.error.title", new Object[0]));
                return;
            }
            File rootFolder = downloadResult.getRootFolder();
            basePath = project.getBasePath();
            assert (basePath != null);
            try {
                String path = sample.getPath();
                if (!Strings.isNullOrEmpty((String)path)) {
                    path = SampleModel.trimSlashes(path);
                    for (File sampleRoot : sampleRoots) {
                        if (!sampleRoot.getCanonicalPath().equals(new File(rootFolder, path).getCanonicalPath())) continue;
                        FileUtil.copyDir((File)sampleRoot, (File)new File(basePath));
                        break block16;
                    }
                    Messages.showErrorDialog((String)GctStudioBundle.message("git.project.missing.sample.root", path), (String)GctStudioBundle.message("sample.import.error.title", new Object[0]));
                    return;
                }
                FileUtil.copyDir((File)sampleRoots.get(0), (File)new File(basePath));
            }
            catch (IOException e) {
                SampleModel.getLog().error((Throwable)e);
                Messages.showErrorDialog((String)GctStudioBundle.message("sample.copy.to.project.failed", new Object[0]), (String)GctStudioBundle.message("sample.import.error.title", new Object[0]));
                return;
            }
        }
        if (SystemInfo.isUnix) {
            File gradlewFile = new File(basePath, "gradlew");
            if (!gradlewFile.isFile()) {
                SampleModel.getLog().error("Could not find gradle wrapper for sample: " + projectName + ". Command line builds may not work properly.");
            } else {
                try {
                    FileUtil.setExecutableAttribute((String)gradlewFile.getPath(), (boolean)true);
                }
                catch (IOException e) {
                    Messages.showWarningDialog((String)GctStudioBundle.message("sample.import.no.gradlew.exec", projectName), (String)GctStudioBundle.message("sample.import.warning.title", new Object[0]));
                }
            }
        }
        UsageTrackerService.getInstance().trackEvent("com.google.cloud.tools", "sample.importer", projectName, null);
        GradleProjectImporter.getInstance().importProject(project.getBaseDir());
    }
}

