/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.appengine.wizard;

import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.ui.ApiComboBoxItem;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStepWithHeaderAndDescription;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.gct.studio.appengine.wizard.CloudTemplateUtils;
import com.google.gct.studio.appengine.wizard.NewCloudModuleDynamicWizardPath;
import com.google.gct.studio.util.GctStudioBundle;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.ui.JBColor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import icons.GoogleCloudToolsIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewCloudModuleDynamicWizardStep
extends DynamicWizardStepWithHeaderAndDescription {
    private static final JBColor CLOUD_HEADER_BACKGROUND_COLOR = new JBColor(2443913, 2443913);
    @NonNls
    static final String STEP_NAME = "New Cloud Module Step";
    private static final List<CloudTemplateUtils.TemplateInfo> CLOUD_TEMPLATES = CloudTemplateUtils.getTemplates();
    private final Project myProject;
    private JPanel myRootPane;
    private JTextField myPackageNameField;
    private JTextField myModuleNameField;
    private JComboBox myClientModuleCombo;
    private JEditorPane myModuleDescriptionText;
    private JComboBox myModuleTypesCombo;
    private JLabel myModuleTypeIcon;

    public NewCloudModuleDynamicWizardStep(@NotNull Project project, @Nullable Disposable parentDisposable) {
        super(GctStudioBundle.message("appengine.wizard.step_body", new Object[0]), null, parentDisposable);
        this.$$$setupUI$$$();
        this.setBodyComponent(this.myRootPane);
        this.myProject = project;
    }

    public void init() {
        super.init();
        this.initModuleTypes();
        this.initClientModuleCombo();
        this.getMessageLabel().setForeground((Color)JBColor.red);
        this.myModuleDescriptionText.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.myModuleDescriptionText.setFont(UIManager.getFont("Label.font"));
        this.myModuleDescriptionText.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    assert (e.getURL() != null);
                    BrowserUtil.browse((String)e.getURL().toString());
                }
            }
        });
        this.register(NewCloudModuleDynamicWizardPath.KEY_MODULE_NAME, this.myModuleNameField);
        this.register(NewCloudModuleDynamicWizardPath.KEY_PACKAGE_NAME, this.myPackageNameField);
        this.register(NewCloudModuleDynamicWizardPath.KEY_CLIENT_MODULE_NAME, this.myClientModuleCombo);
        this.register(NewCloudModuleDynamicWizardPath.KEY_SELECTED_TEMPLATE_FILE, this.myModuleTypesCombo);
        this.myModuleTypesCombo.setSelectedIndex(0);
        if (this.myClientModuleCombo.getItemCount() == 1) {
            this.myClientModuleCombo.setSelectedIndex(0);
        }
    }

    private void initModuleTypes() {
        for (CloudTemplateUtils.TemplateInfo template : CLOUD_TEMPLATES) {
            this.myModuleTypesCombo.addItem(new ApiComboBoxItem((Object)template.getFile(), template.getMetadata().getTitle(), 1, 1));
        }
    }

    private void initClientModuleCombo() {
        Module[] modules;
        for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            String packageName;
            AndroidFacet facet = AndroidFacet.getInstance((Module)module);
            if (facet == null || ModuleRootManager.getInstance((Module)module).getContentRoots().length <= 0) continue;
            String moduleNameLabel = module.getName();
            if (facet.getManifest() != null && !Strings.isNullOrEmpty((String)(packageName = (String)facet.getManifest().getPackage().getValue()))) {
                moduleNameLabel = moduleNameLabel + String.format(" (%s)", packageName);
            }
            this.myClientModuleCombo.addItem(new ApiComboBoxItem((Object)module.getName(), moduleNameLabel, 1, 1));
        }
    }

    private void setModuleDescriptionText(@NotNull File templateFile) {
        Parameter docUrlParam = null;
        TemplateMetadata metadata = null;
        for (CloudTemplateUtils.TemplateInfo templateInfo : CLOUD_TEMPLATES) {
            if (templateFile != templateInfo.getFile()) continue;
            metadata = templateInfo.getMetadata();
            assert (metadata != null);
            docUrlParam = metadata.getParameter("docUrl");
        }
        assert (metadata != null);
        assert (docUrlParam != null);
        this.myModuleDescriptionText.setText(GctStudioBundle.message("appengine.wizard.module_type_description", docUrlParam.initial, metadata.getTitle()));
    }

    private void setModuleTypeIcon(@NotNull File templateFile) {
        for (CloudTemplateUtils.TemplateInfo templateInfo : CLOUD_TEMPLATES) {
            TemplateMetadata metadata;
            Parameter docUrlParam;
            if (templateFile != templateInfo.getFile() || (docUrlParam = (metadata = templateInfo.getMetadata()).getParameter("moduleType")) == null || docUrlParam.initial == null) continue;
            if (docUrlParam.initial.equals("Servlet")) {
                this.myModuleTypeIcon.setIcon(GoogleCloudToolsIcons.SERVLET_CARD);
                continue;
            }
            if (docUrlParam.initial.equals("Endpoints")) {
                this.myModuleTypeIcon.setIcon(GoogleCloudToolsIcons.ENDPOINTS_CARD);
                continue;
            }
            if (!docUrlParam.initial.equals("Gcm")) continue;
            this.myModuleTypeIcon.setIcon(GoogleCloudToolsIcons.GCM_CARD);
        }
    }

    public void deriveValues(Set<ScopedStateStore.Key> modified) {
        super.deriveValues(modified);
        for (ScopedStateStore.Key key : modified) {
            File templateFile;
            if (key != NewCloudModuleDynamicWizardPath.KEY_SELECTED_TEMPLATE_FILE || (templateFile = (File)this.myState.get(NewCloudModuleDynamicWizardPath.KEY_SELECTED_TEMPLATE_FILE)) == null) continue;
            this.setModuleDescriptionText(templateFile);
            this.setModuleTypeIcon(templateFile);
        }
    }

    public boolean validate() {
        File templateFile = (File)this.myState.get(NewCloudModuleDynamicWizardPath.KEY_SELECTED_TEMPLATE_FILE);
        String moduleName = (String)this.myState.get(NewCloudModuleDynamicWizardPath.KEY_MODULE_NAME);
        String packageName = (String)this.myState.get(NewCloudModuleDynamicWizardPath.KEY_PACKAGE_NAME);
        String clientModuleName = (String)this.myState.get(NewCloudModuleDynamicWizardPath.KEY_CLIENT_MODULE_NAME);
        assert (moduleName != null && packageName != null);
        if (templateFile == null) {
            this.setErrorHtml(GctStudioBundle.message("appengine.wizard.please_select_module_type", new Object[0]));
            return false;
        }
        if (moduleName.isEmpty()) {
            this.setErrorHtml(GctStudioBundle.message("appengine.wizard.please_select_module_name", new Object[0]));
            return false;
        }
        if (!NewCloudModuleDynamicWizardStep.isValidModuleName(moduleName)) {
            this.setErrorHtml(GctStudioBundle.message("appengine.wizard.please_enter_valid_module_name", new Object[0]));
            return false;
        }
        if (ModuleManager.getInstance((Project)this.myProject).findModuleByName(moduleName) != null || new File(this.myProject.getBasePath(), moduleName).exists()) {
            this.setErrorHtml(GctStudioBundle.message("appengine.wizard.module_already_exists", moduleName));
            return false;
        }
        if (packageName.isEmpty()) {
            this.setErrorHtml(GctStudioBundle.message("appengine.wizard.please_enter_package_name", new Object[0]));
            return false;
        }
        if (!PsiNameHelper.getInstance((Project)this.myProject).isQualifiedName(packageName)) {
            this.setErrorHtml(GctStudioBundle.message("appengine.wizard.please_enter_valid_package_name", new Object[0]));
            return false;
        }
        if (Strings.isNullOrEmpty((String)clientModuleName)) {
            this.setErrorHtml(GctStudioBundle.message("appengine.wizard.please_select_client_module", new Object[0]));
            return false;
        }
        this.setErrorHtml("");
        return true;
    }

    static boolean isValidModuleName(@NotNull String moduleName) {
        if (!moduleName.replaceAll("[/\\\\?%*:|\"<>!;]", "").equals(moduleName)) {
            return false;
        }
        for (String s : Splitter.on((char)'.').split((CharSequence)moduleName)) {
            if (!WizardConstants.INVALID_WINDOWS_FILENAMES.contains(s.toLowerCase())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String getStepName() {
        return STEP_NAME;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myModuleTypesCombo;
    }

    @NotNull
    protected DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings getStepHeader() {
        return DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings.createCustomColorHeader((JBColor)CLOUD_HEADER_BACKGROUND_COLOR, (String)GctStudioBundle.message("appengine.wizard.step_title", new Object[0]));
    }

    @Nullable
    protected Icon getWizardIcon() {
        return GoogleCloudToolsIcons.CLOUD_60x60;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JComboBox jComboBox;
        JEditorPane jEditorPane;
        JComboBox jComboBox2;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        this.myRootPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(32, 4, 32, 4), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/CloudToolsBundle").getString("appengine.wizard.module_name_label"));
        jLabel2.setToolTipText(ResourceBundle.getBundle("messages/CloudToolsBundle").getString("appengine.wizard.module_name_label_hint"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myModuleNameField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(1, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/CloudToolsBundle").getString("appengine.wizard.package_name_label"));
        jLabel3.setToolTipText(ResourceBundle.getBundle("messages/CloudToolsBundle").getString("appengine.wizard.package_name_label_hint"));
        jPanel.add((Component)jLabel3, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPackageNameField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/CloudToolsBundle").getString("appengine.wizard.client_module_label"));
        jLabel4.setToolTipText(ResourceBundle.getBundle("messages/CloudToolsBundle").getString("appengine.wizard.client_module_label_hint"));
        jPanel.add((Component)jLabel4, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myClientModuleCombo = jComboBox2 = new JComboBox();
        jPanel.add(jComboBox2, new GridConstraints(3, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myModuleDescriptionText = jEditorPane = new JEditorPane();
        jEditorPane.setOpaque(false);
        jEditorPane.setContentType("text/html");
        jEditorPane.setEditable(false);
        jEditorPane.setMargin(new Insets(4, 0, 0, 0));
        jPanel.add((Component)jEditorPane, new GridConstraints(4, 1, 1, 2, 0, 3, 0, 0, null, new Dimension(150, 50), null));
        this.myModuleTypesCombo = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/CloudToolsBundle").getString("appengine.wizard.module_type_label"));
        jLabel5.setToolTipText(ResourceBundle.getBundle("messages/CloudToolsBundle").getString("appengine.wizard.module_type_label_hint"));
        jPanel.add((Component)jLabel5, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myModuleTypeIcon = jLabel = new JLabel();
        jLabel.setVerticalAlignment(1);
        jLabel.setText("");
        jLabel.setVerticalTextPosition(3);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 6, 1, 8, 2, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

