/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.protocol.handlers;

import com.glavsoft.exceptions.AuthenticationFailedException;
import com.glavsoft.exceptions.FatalException;
import com.glavsoft.exceptions.TransportException;
import com.glavsoft.exceptions.UnsupportedProtocolVersionException;
import com.glavsoft.exceptions.UnsupportedSecurityTypeException;
import com.glavsoft.rfb.protocol.Protocol;
import com.glavsoft.rfb.protocol.auth.AuthHandler;
import com.glavsoft.rfb.protocol.auth.NoneAuthentication;
import com.glavsoft.rfb.protocol.auth.SecurityType;
import com.glavsoft.rfb.protocol.auth.TightAuthentication;
import com.glavsoft.rfb.protocol.auth.VncAuthentication;
import com.glavsoft.rfb.protocol.tunnel.SslTunnel;
import com.glavsoft.rfb.protocol.tunnel.TunnelType;
import com.glavsoft.transport.Transport;
import com.glavsoft.utils.Strings;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Handshaker {
    private static final int PROTOCOL_STRING_LENGTH = 12;
    private static final String PROTOCOL_STRING_REGEXP = "^RFB (\\d\\d\\d).(\\d\\d\\d)\n$";
    private static final int MIN_SUPPORTED_VERSION_MAJOR = 3;
    private static final int MIN_SUPPORTED_VERSION_MINOR = 3;
    private static final int MAX_SUPPORTED_VERSION_MAJOR = 3;
    private static final int MAX_SUPPORTED_VERSION_MINOR = 8;
    private Protocol protocol;
    private Logger logger;
    private final Map<Integer, AuthHandler> registeredAuthHandlers = new HashMap<Integer, AuthHandler>();

    public Handshaker(Protocol protocol) {
        this.protocol = protocol;
        this.logger = Logger.getLogger(this.getClass().getName());
        this.registerAuthHandler(SecurityType.NONE_AUTHENTICATION.getId(), new NoneAuthentication());
        this.registerAuthHandler(SecurityType.VNC_AUTHENTICATION.getId(), new VncAuthentication());
        TightAuthentication tightAuthentication = new TightAuthentication();
        tightAuthentication.registerAuthHandler(new NoneAuthentication());
        tightAuthentication.registerAuthHandler(new VncAuthentication());
        if (protocol.getSettings().getTunnelType() != TunnelType.NOTUNNEL && SslTunnel.isTransportAvailable()) {
            tightAuthentication.registerTunnelingHandler(new SslTunnel());
            this.registerAuthHandler(SecurityType.TIGHT2_AUTHENTICATION.getId(), tightAuthentication);
        }
        this.registerAuthHandler(SecurityType.TIGHT_AUTHENTICATION.getId(), tightAuthentication);
    }

    public Transport handshake(Transport transport) throws TransportException, UnsupportedProtocolVersionException, AuthenticationFailedException, FatalException, UnsupportedSecurityTypeException {
        ProtocolVersion ver = this.matchProtocolVersion(transport);
        int n = ver.major;
        int n2 = ver.minor;
        transport.write(Strings.getBytesWithCharset(new StringBuilder(32).append("RFB 00").append(n).append(".00").append(n2).append("\n").toString(), Transport.ISO_8859_1)).flush();
        this.protocol.setProtocolVersion(ver);
        String string = String.valueOf((Object)ver);
        this.logger.info(new StringBuilder(25 + String.valueOf(string).length()).append("Set protocol version to: ").append(string).toString());
        transport = this.auth(transport, ver);
        return transport;
    }

    private ProtocolVersion matchProtocolVersion(Transport transport) throws TransportException, UnsupportedProtocolVersionException {
        ProtocolVersion ver;
        String protocolString = transport.readString(12);
        String string = String.valueOf(protocolString.substring(0, protocolString.length() - 1));
        this.logger.info(string.length() != 0 ? "Server protocol string: ".concat(string) : new String("Server protocol string: "));
        Pattern pattern = Pattern.compile(PROTOCOL_STRING_REGEXP);
        Matcher matcher = pattern.matcher(protocolString);
        if (!matcher.matches()) {
            String string2 = String.valueOf(protocolString);
            throw new UnsupportedProtocolVersionException(string2.length() != 0 ? "Unsupported protocol version: ".concat(string2) : new String("Unsupported protocol version: "));
        }
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        boolean isMac = false;
        if (889 == minor) {
            isMac = true;
        }
        if (major < 3 || 3 == major && minor < 3) {
            int n = minor;
            throw new UnsupportedProtocolVersionException(new StringBuilder(53).append("Unsupported protocol version: ").append(major).append(".").append(n).toString());
        }
        if (major > 3) {
            minor = 8;
        }
        if (minor >= 3 && minor < 7) {
            ver = ProtocolVersion.PROTOCOL_VERSION_3_3;
        } else if (7 == minor) {
            ver = ProtocolVersion.PROTOCOL_VERSION_3_7;
        } else if (minor >= 8) {
            ver = ProtocolVersion.PROTOCOL_VERSION_3_8;
        } else {
            String string3 = String.valueOf(protocolString);
            throw new UnsupportedProtocolVersionException(string3.length() != 0 ? "Unsupported protocol version: ".concat(string3) : new String("Unsupported protocol version: "));
        }
        this.protocol.setMac(isMac);
        return ver;
    }

    private Transport auth(Transport transport, ProtocolVersion ver) throws UnsupportedSecurityTypeException, TransportException, FatalException, AuthenticationFailedException {
        AuthHandler handler;
        switch (ver) {
            case PROTOCOL_VERSION_3_3: {
                handler = this.auth33(transport);
                break;
            }
            case PROTOCOL_VERSION_3_7: {
                handler = this.auth37_38(transport);
                break;
            }
            case PROTOCOL_VERSION_3_8: {
                handler = this.auth37_38(transport);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        transport = handler.authenticate(transport, this.protocol);
        if (ver == ProtocolVersion.PROTOCOL_VERSION_3_8 || handler.getType() != SecurityType.NONE_AUTHENTICATION) {
            handler.checkSecurityResult(transport);
        }
        handler.initProcedure(transport, this.protocol);
        return transport;
    }

    private AuthHandler auth33(Transport transport) throws TransportException, UnsupportedSecurityTypeException {
        int type = transport.readInt32();
        this.logger.info(new StringBuilder(26).append("Type received: ").append(type).toString());
        if (0 == type) {
            throw new UnsupportedSecurityTypeException(transport.readString());
        }
        AuthHandler handler = this.registeredAuthHandlers.get(this.selectAuthHandlerId(new byte[]{(byte)(0xFF & type)}));
        return handler;
    }

    private AuthHandler auth37_38(Transport transport) throws TransportException, UnsupportedSecurityTypeException {
        int secTypesNum = transport.readUInt8();
        if (0 == secTypesNum) {
            throw new UnsupportedSecurityTypeException(transport.readString());
        }
        byte[] secTypes = transport.readBytes(secTypesNum);
        String string = Strings.toString(secTypes);
        this.logger.info(new StringBuilder(39 + String.valueOf(string).length()).append("Security Types received (").append(secTypesNum).append("): ").append(string).toString());
        int typeIdAccepted = this.selectAuthHandlerId(secTypes);
        AuthHandler authHandler = this.registeredAuthHandlers.get(typeIdAccepted);
        transport.writeByte(typeIdAccepted).flush();
        return authHandler;
    }

    private int selectAuthHandlerId(byte[] secTypes) throws UnsupportedSecurityTypeException, TransportException {
        AuthHandler handler;
        for (byte type : secTypes) {
            if (SecurityType.TIGHT2_AUTHENTICATION.getId() != (0xFF & type) || (handler = this.registeredAuthHandlers.get(SecurityType.TIGHT2_AUTHENTICATION.getId())) == null) continue;
            String string = String.valueOf(SecurityType.TIGHT2_AUTHENTICATION.name());
            this.logger.info(string.length() != 0 ? "Security Type accepted: ".concat(string) : new String("Security Type accepted: "));
            return SecurityType.TIGHT2_AUTHENTICATION.getId();
        }
        for (byte type : secTypes) {
            if (SecurityType.TIGHT_AUTHENTICATION.getId() != (0xFF & type) || (handler = this.registeredAuthHandlers.get(SecurityType.TIGHT_AUTHENTICATION.getId())) == null) continue;
            String string = String.valueOf(SecurityType.TIGHT_AUTHENTICATION.name());
            this.logger.info(string.length() != 0 ? "Security Type accepted: ".concat(string) : new String("Security Type accepted: "));
            return SecurityType.TIGHT_AUTHENTICATION.getId();
        }
        for (byte type : secTypes) {
            handler = this.registeredAuthHandlers.get(0xFF & type);
            if (handler == null) continue;
            String string = String.valueOf((Object)handler.getType());
            this.logger.info(new StringBuilder(24 + String.valueOf(string).length()).append("Security Type accepted: ").append(string).toString());
            return handler.getType().getId();
        }
        String string = Strings.toString(secTypes);
        throw new UnsupportedSecurityTypeException(new StringBuilder(95 + String.valueOf(string).length()).append("No security types supported. Server sent '").append(string).append("' security types, but we do not support any of their.").toString());
    }

    private void registerAuthHandler(int id, AuthHandler handler) {
        this.registeredAuthHandlers.put(id, handler);
    }

    public static enum ProtocolVersion {
        PROTOCOL_VERSION_3_3(3, 3),
        PROTOCOL_VERSION_3_7(3, 7),
        PROTOCOL_VERSION_3_8(3, 8);

        public final int minor;
        public final int major;

        private ProtocolVersion(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }

        public String toString() {
            String string = String.valueOf(String.valueOf(this.major));
            String string2 = String.valueOf(String.valueOf(this.minor));
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".").append(string2).toString();
        }
    }
}

