/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.shrinker;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.shrinker.AbstractShrinker;
import com.android.build.gradle.shrinker.DependencyRemoverVisitor;
import com.android.build.gradle.shrinker.IncrementalRunVisitor;
import com.android.build.gradle.shrinker.PostProcessingData;
import com.android.build.gradle.shrinker.ShrinkerGraph;
import com.android.build.gradle.shrinker.ShrinkerLogger;
import com.android.ide.common.internal.WaitableExecutor;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.objectweb.asm.ClassReader;

public class IncrementalShrinker<T>
extends AbstractShrinker<T> {
    public IncrementalShrinker(WaitableExecutor<Void> executor, ShrinkerGraph<T> graph, ShrinkerLogger shrinkerLogger) {
        super(graph, executor, shrinkerLogger);
    }

    public void incrementalRun(Iterable<TransformInput> inputs, TransformOutputProvider output) throws IOException, IncrementalRunImpossibleException {
        Set classesToWrite = Sets.newConcurrentHashSet();
        Set classFilesToDelete = Sets.newConcurrentHashSet();
        Set unresolvedReferences = Sets.newConcurrentHashSet();
        Stopwatch stopwatch = Stopwatch.createStarted();
        SetMultimap<T, String> oldState = this.resetState();
        IncrementalShrinker.logTime("resetState()", stopwatch);
        this.processInputs(inputs, classesToWrite, unresolvedReferences);
        IncrementalShrinker.logTime("processInputs", stopwatch);
        this.finishGraph(unresolvedReferences);
        IncrementalShrinker.logTime("finish graph", stopwatch);
        this.setCounters(AbstractShrinker.CounterSet.SHRINK);
        IncrementalShrinker.logTime("set counters", stopwatch);
        this.chooseClassesToWrite(inputs, output, classesToWrite, classFilesToDelete, oldState);
        IncrementalShrinker.logTime("choose classes", stopwatch);
        this.updateClassFiles(classesToWrite, classFilesToDelete, inputs, output);
        IncrementalShrinker.logTime("update class files", stopwatch);
        this.mGraph.saveState();
        IncrementalShrinker.logTime("save state", stopwatch);
    }

    private void chooseClassesToWrite(Iterable<TransformInput> inputs, TransformOutputProvider output, Collection<T> classesToWrite, Collection<File> classFilesToDelete, SetMultimap<T, String> oldState) {
        for (Object klass : this.mGraph.getReachableClasses(AbstractShrinker.CounterSet.SHRINK)) {
            if (!oldState.containsKey(klass)) {
                classesToWrite.add(klass);
            } else {
                Set<String> newMembers = this.mGraph.getReachableMembersLocalNames(klass, AbstractShrinker.CounterSet.SHRINK);
                Set oldMembers = oldState.get(klass);
                if (oldMembers.size() == 1) {
                    oldMembers.remove(this.mGraph.getClassName(klass));
                }
                if (!((Object)newMembers).equals(oldMembers)) {
                    classesToWrite.add(klass);
                }
            }
            oldState.removeAll(klass);
        }
        for (Object klass : oldState.keySet()) {
            File sourceFile = this.mGraph.getSourceFile(klass);
            Preconditions.checkState((sourceFile != null ? 1 : 0) != 0, (Object)"One of the inputs has no source file.");
            Optional<File> outputFile = this.chooseOutputFile(klass, sourceFile, inputs, output);
            if (!outputFile.isPresent()) {
                throw new IllegalStateException("Can't determine path of " + this.mGraph.getClassName(klass));
            }
            classFilesToDelete.add((File)outputFile.get());
        }
    }

    private SetMultimap<T, String> resetState() {
        HashMultimap oldState = HashMultimap.create();
        for (Object klass : this.mGraph.getReachableClasses(AbstractShrinker.CounterSet.SHRINK)) {
            Set<String> reachableMembers = this.mGraph.getReachableMembersLocalNames(klass, AbstractShrinker.CounterSet.SHRINK);
            for (String member : reachableMembers) {
                oldState.put(klass, (Object)member);
            }
            if (!reachableMembers.isEmpty()) continue;
            oldState.put(klass, (Object)this.mGraph.getClassName(klass));
        }
        this.mGraph.clearCounters((WaitableExecutor<Void>)this.mExecutor);
        this.waitForAllTasks();
        return oldState;
    }

    private void finishGraph(Iterable<PostProcessingData.UnresolvedReference<T>> unresolvedReferences) {
        this.resolveReferences(unresolvedReferences);
        this.waitForAllTasks();
    }

    private void processInputs(Iterable<TransformInput> inputs, final Collection<T> classesToWrite, final Collection<PostProcessingData.UnresolvedReference<T>> unresolvedReferences) throws IncrementalRunImpossibleException {
        for (TransformInput input : inputs) {
            for (JarInput jarInput : input.getJarInputs()) {
                switch (jarInput.getStatus()) {
                    case ADDED: 
                    case REMOVED: 
                    case CHANGED: {
                        throw new IncrementalRunImpossibleException(String.format("Input jar %s has been %s.", jarInput.getFile(), jarInput.getStatus().name().toLowerCase()));
                    }
                }
            }
            for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
                for (final Map.Entry changedFile : directoryInput.getChangedFiles().entrySet()) {
                    this.mExecutor.execute((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            switch ((Status)changedFile.getValue()) {
                                case ADDED: {
                                    throw new IncrementalRunImpossibleException(String.format("File %s added.", changedFile.getKey()));
                                }
                                case REMOVED: {
                                    throw new IncrementalRunImpossibleException(String.format("File %s removed.", changedFile.getKey()));
                                }
                                case CHANGED: {
                                    IncrementalShrinker.this.processChangedClassFile((File)changedFile.getKey(), unresolvedReferences, classesToWrite);
                                }
                            }
                            return null;
                        }
                    });
                }
            }
        }
        this.waitForAllTasks();
    }

    private void processChangedClassFile(File file, Collection<PostProcessingData.UnresolvedReference<T>> unresolvedReferences, Collection<T> classesToWrite) throws IOException, IncrementalRunImpossibleException {
        ClassReader classReader = new ClassReader(Files.toByteArray((File)file));
        IncrementalRunVisitor<T> visitor = new IncrementalRunVisitor<T>(this.mGraph, classesToWrite, unresolvedReferences);
        DependencyRemoverVisitor remover = new DependencyRemoverVisitor(this.mGraph, visitor);
        classReader.accept(remover, 0);
    }

    @Override
    protected void waitForAllTasks() {
        try {
            super.waitForAllTasks();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IncrementalRunImpossibleException) {
                throw (IncrementalRunImpossibleException)e.getCause();
            }
            throw e;
        }
    }

    public static class IncrementalRunImpossibleException
    extends RuntimeException {
        IncrementalRunImpossibleException(String message) {
            super(message);
        }

        IncrementalRunImpossibleException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

