/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.shrinker;

import com.android.build.gradle.shrinker.AbstractShrinker;
import com.android.build.gradle.shrinker.DependencyType;
import com.android.build.gradle.shrinker.PostProcessingData;
import com.android.build.gradle.shrinker.ShrinkerGraph;
import com.android.utils.AsmUtils;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayDeque;
import java.util.Deque;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

abstract class DependencyFinderVisitor<T>
extends ClassVisitor {
    private final ShrinkerGraph<T> mGraph;
    private String mClassName;
    private boolean mIsAnnotation;
    private T mKlass;

    DependencyFinderVisitor(ShrinkerGraph<T> graph, ClassVisitor cv) {
        super(327680, cv);
        this.mGraph = graph;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (interfaces == null) {
            interfaces = new String[]{};
        }
        this.mKlass = this.mGraph.getClassReference(name);
        if (superName != null && !AbstractShrinker.isSdkPackage(superName)) {
            this.handleDependency(this.mKlass, this.mGraph.getClassReference(superName), DependencyType.REQUIRED_CLASS_STRUCTURE);
        }
        if (interfaces.length > 0) {
            this.handleInterfaceInheritance(this.mKlass);
            if (!Objects.equal((Object)superName, (Object)"java/lang/Object")) {
                this.handleMultipleInheritance(this.mKlass);
            }
        }
        this.mClassName = name;
        boolean bl = this.mIsAnnotation = (access & 0x2000) != 0;
        if (signature != null) {
            this.handleClassSignature(this.mKlass, signature);
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        T method = this.mGraph.getMemberReference(this.mClassName, name, desc);
        if ((access & 8) == 0 && !name.equals("<init>")) {
            this.handleVirtualMethod(method);
        }
        Type methodType = Type.getMethodType((String)desc);
        this.handleDeclarationType(method, methodType.getReturnType());
        for (Type argType : methodType.getArgumentTypes()) {
            this.handleDeclarationType(method, argType);
        }
        if (name.equals("<clinit>")) {
            this.handleDependency(this.mKlass, method, DependencyType.REQUIRED_CLASS_STRUCTURE);
        }
        if (this.mIsAnnotation) {
            this.handleDependency(this.mKlass, method, DependencyType.REQUIRED_CLASS_STRUCTURE);
        }
        if (signature != null) {
            this.handleClassSignature(method, signature);
        }
        return new DependencyFinderMethodVisitor(method, super.visitMethod(access, name, desc, signature, exceptions));
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        T field = this.mGraph.getMemberReference(this.mClassName, name, desc);
        Type fieldType = Type.getType((String)desc);
        this.handleDeclarationType(field, fieldType);
        if (signature != null) {
            SignatureReader reader = new SignatureReader(signature);
            DependencyFinderSignatureVisitor visitor = new DependencyFinderSignatureVisitor(field);
            reader.acceptType((SignatureVisitor)visitor);
        }
        return super.visitField(access, name, desc, signature, value);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (!visible) {
            return super.visitAnnotation(desc, false);
        }
        Type type = Type.getType((String)desc);
        this.handleDeclarationType(this.mKlass, type);
        return new DependencyFinderAnnotationVisitor(type.getInternalName(), this.mKlass, super.visitAnnotation(desc, true));
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (this.mClassName.equals(name) && outerName != null) {
            this.handleDependency(this.mKlass, this.mGraph.getClassReference(outerName), DependencyType.REQUIRED_CLASS_STRUCTURE);
        }
        super.visitInnerClass(name, outerName, innerName, access);
    }

    private void handleDeclarationType(T member, Type type) {
        String className = DependencyFinderVisitor.getClassName(type);
        if (className != null && !AbstractShrinker.isSdkPackage(className)) {
            T classReference = this.mGraph.getClassReference(className);
            this.handleDependency(member, classReference, DependencyType.REQUIRED_CLASS_STRUCTURE);
        }
    }

    private void handleClassSignature(T source, String signature) {
        SignatureReader reader = new SignatureReader(signature);
        DependencyFinderSignatureVisitor visitor = new DependencyFinderSignatureVisitor(source);
        reader.accept((SignatureVisitor)visitor);
    }

    private static String getClassName(String desc) {
        return DependencyFinderVisitor.getClassName(Type.getType((String)desc));
    }

    private static String getClassName(Type type) {
        switch (type.getSort()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                return null;
            }
            case 9: {
                return DependencyFinderVisitor.getClassName(type.getElementType());
            }
            case 10: {
                return type.getInternalName();
            }
        }
        throw new IllegalStateException();
    }

    protected abstract void handleDependency(T var1, T var2, DependencyType var3);

    protected abstract void handleMultipleInheritance(T var1);

    protected abstract void handleVirtualMethod(T var1);

    protected abstract void handleInterfaceInheritance(T var1);

    protected abstract void handleUnresolvedReference(PostProcessingData.UnresolvedReference<T> var1);

    private static enum ReflectionMethod {
        CLASS_FOR_NAME("java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;"){

            @Override
            public <T> T getMember(ShrinkerGraph<T> graph, Deque<Object> stack) {
                if (!(stack.peek() instanceof String)) {
                    return null;
                }
                return graph.getClassReference(AsmUtils.toInternalName((String)((String)stack.pop())));
            }
        }
        ,
        ATOMIC_INTEGER_FIELD_UPDATER("java/util/concurrent/atomic/AtomicIntegerFieldUpdater", "newUpdater", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/util/concurrent/atomic/AtomicIntegerFieldUpdater;"){

            @Override
            public <T> T getMember(ShrinkerGraph<T> graph, Deque<Object> stack) {
                return (T)ReflectionMethod.primitiveFieldUpdater(graph, stack, "I");
            }
        }
        ,
        ATOMIC_LONG_FIELD_UPDATER("java/util/concurrent/atomic/AtomicLongFieldUpdater", "newUpdater", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/util/concurrent/atomic/AtomicLongFieldUpdater;"){

            @Override
            public <T> T getMember(ShrinkerGraph<T> graph, Deque<Object> stack) {
                return (T)ReflectionMethod.primitiveFieldUpdater(graph, stack, "J");
            }
        }
        ,
        ATOMIC_REFERENCE_FIELD_UPDATER("java/util/concurrent/atomic/AtomicReferenceFieldUpdater", "newUpdater", "(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/String;)Ljava/util/concurrent/atomic/AtomicReferenceFieldUpdater;"){

            @Override
            public <T> T getMember(ShrinkerGraph<T> graph, Deque<Object> stack) {
                if (!(stack.peek() instanceof String)) {
                    return null;
                }
                String fieldName = (String)stack.pop();
                if (!(stack.peek() instanceof Type)) {
                    return null;
                }
                Type fieldType = (Type)stack.pop();
                if (!(stack.peek() instanceof Type)) {
                    return null;
                }
                Type klass = (Type)stack.pop();
                return graph.getMemberReference(klass.getInternalName(), fieldName, fieldType.getDescriptor());
            }
        };

        private static final ImmutableMap<Signature, ReflectionMethod> BY_SIGNATURE;
        private Signature mSignature;

        public static ReflectionMethod findBySignature(Signature signature) {
            return (ReflectionMethod)((Object)BY_SIGNATURE.get((Object)signature));
        }

        private ReflectionMethod(String owner, String name, String desc) {
            this.mSignature = new Signature(owner, name, desc);
        }

        public Signature getSignature() {
            return this.mSignature;
        }

        public abstract <T> T getMember(ShrinkerGraph<T> var1, Deque<Object> var2);

        private static <T> T primitiveFieldUpdater(ShrinkerGraph<T> graph, Deque<Object> stack, String desc) {
            if (!(stack.peek() instanceof String)) {
                return null;
            }
            String fieldName = (String)stack.pop();
            if (!(stack.peek() instanceof Type)) {
                return null;
            }
            Type type = (Type)stack.pop();
            return graph.getMemberReference(type.getInternalName(), fieldName, desc);
        }

        static {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (ReflectionMethod reflectionMethod : ReflectionMethod.values()) {
                builder.put((Object)reflectionMethod.getSignature(), (Object)reflectionMethod);
            }
            BY_SIGNATURE = builder.build();
        }
    }

    private static class Signature {
        private final String owner;
        private final String name;
        private final String desc;

        Signature(String owner, String name, String desc) {
            this.owner = owner;
            this.name = name;
            this.desc = desc;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Signature method = (Signature)o;
            return Objects.equal((Object)this.owner, (Object)method.owner) && Objects.equal((Object)this.name, (Object)method.name) && Objects.equal((Object)this.desc, (Object)method.desc);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.owner, this.name, this.desc});
        }
    }

    private class DependencyFinderSignatureVisitor
    extends SignatureVisitor {
        private final T mSource;

        DependencyFinderSignatureVisitor(T source) {
            super(327680);
            this.mSource = source;
        }

        public void visitClassType(String name) {
            if (!AbstractShrinker.isSdkPackage(name)) {
                DependencyFinderVisitor.this.handleDependency(this.mSource, DependencyFinderVisitor.this.mGraph.getClassReference(name), DependencyType.REQUIRED_CLASS_STRUCTURE);
            }
            super.visitClassType(name);
        }
    }

    private class DependencyFinderAnnotationVisitor
    extends AnnotationVisitor {
        private final String mAnnotationName;
        private final T mSource;

        DependencyFinderAnnotationVisitor(String annotationName, T source, AnnotationVisitor av) {
            super(327680, av);
            this.mAnnotationName = annotationName;
            this.mSource = source;
        }

        public void visit(String name, Object value) {
            if (value instanceof Type) {
                DependencyFinderVisitor.this.handleDeclarationType(this.mSource, (Type)value);
            }
            super.visit(name, value);
        }

        public void visitEnum(String name, String desc, String value) {
            String internalName = DependencyFinderVisitor.getClassName(desc);
            if (internalName != null) {
                DependencyFinderVisitor.this.handleDependency(this.mSource, DependencyFinderVisitor.this.mGraph.getClassReference(internalName), DependencyType.REQUIRED_CLASS_STRUCTURE);
                DependencyFinderVisitor.this.handleDependency(this.mSource, DependencyFinderVisitor.this.mGraph.getMemberReference(internalName, value, desc), DependencyType.REQUIRED_CLASS_STRUCTURE);
            }
            super.visitEnum(name, desc, value);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            String internalName = DependencyFinderVisitor.getClassName(desc);
            if (internalName != null) {
                DependencyFinderVisitor.this.handleDependency(this.mSource, DependencyFinderVisitor.this.mGraph.getClassReference(internalName), DependencyType.REQUIRED_CLASS_STRUCTURE);
            }
            return new DependencyFinderAnnotationVisitor(this.mAnnotationName, this.mSource, super.visitAnnotation(name, desc));
        }

        public AnnotationVisitor visitArray(String name) {
            return new DependencyFinderAnnotationVisitor(this.mAnnotationName, this.mSource, super.visitArray(name));
        }
    }

    private class DependencyFinderMethodVisitor
    extends MethodVisitor {
        private final T mMethod;
        private final Deque<Object> mLastLdcs;

        DependencyFinderMethodVisitor(T method, MethodVisitor mv) {
            super(327680, mv);
            this.mMethod = method;
            this.mLastLdcs = new ArrayDeque<Object>();
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (!visible) {
                return super.visitAnnotation(desc, false);
            }
            Type type = Type.getType((String)desc);
            DependencyFinderVisitor.this.handleDeclarationType(this.mMethod, type);
            return new DependencyFinderAnnotationVisitor(type.getInternalName(), this.mMethod, super.visitAnnotation(desc, true));
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return new DependencyFinderAnnotationVisitor(null, this.mMethod, super.visitAnnotationDefault());
        }

        public void visitTypeInsn(int opcode, String type) {
            String className = DependencyFinderVisitor.getClassName(Type.getObjectType((String)type));
            if (className != null && !AbstractShrinker.isSdkPackage(className)) {
                Object classReference = DependencyFinderVisitor.this.mGraph.getClassReference(className);
                DependencyFinderVisitor.this.handleDependency(this.mMethod, classReference, DependencyType.REQUIRED_CODE_REFERENCE);
            }
            this.mLastLdcs.clear();
            super.visitTypeInsn(opcode, type);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (!AbstractShrinker.isSdkPackage(owner)) {
                DependencyFinderVisitor.this.handleDependency(this.mMethod, DependencyFinderVisitor.this.mGraph.getClassReference(owner), DependencyType.REQUIRED_CODE_REFERENCE);
                Object target = DependencyFinderVisitor.this.mGraph.getMemberReference(owner, name, desc);
                DependencyFinderVisitor.this.handleUnresolvedReference(new PostProcessingData.UnresolvedReference(this.mMethod, target, opcode == 183));
            }
            this.mLastLdcs.clear();
            super.visitFieldInsn(opcode, owner, name, desc);
        }

        public void visitLdcInsn(Object cst) {
            Type type;
            String className;
            if (cst instanceof Type && (className = DependencyFinderVisitor.getClassName(type = Type.getObjectType((String)((Type)cst).getInternalName()))) != null && !AbstractShrinker.isSdkPackage(className)) {
                Object classReference = DependencyFinderVisitor.this.mGraph.getClassReference(className);
                DependencyFinderVisitor.this.handleDependency(this.mMethod, classReference, DependencyType.REQUIRED_CODE_REFERENCE);
            }
            this.mLastLdcs.push(cst);
            super.visitLdcInsn(cst);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            ReflectionMethod reflectionMethod;
            Type type = Type.getType((String)owner);
            if (type.getSort() != 9 && !AbstractShrinker.isSdkPackage(owner)) {
                DependencyFinderVisitor.this.handleDependency(this.mMethod, DependencyFinderVisitor.this.mGraph.getClassReference(owner), DependencyType.REQUIRED_CODE_REFERENCE);
                Object target = DependencyFinderVisitor.this.mGraph.getMemberReference(owner, name, desc);
                if (opcode == 183 && (name.equals("<init>") || owner.equals(DependencyFinderVisitor.this.mClassName))) {
                    DependencyFinderVisitor.this.handleDependency(this.mMethod, target, DependencyType.REQUIRED_CODE_REFERENCE);
                } else {
                    DependencyFinderVisitor.this.handleUnresolvedReference(new PostProcessingData.UnresolvedReference(this.mMethod, target, opcode == 183));
                }
            }
            if ((reflectionMethod = ReflectionMethod.findBySignature(new Signature(owner, name, desc))) != null) {
                ArrayDeque<Object> stackCopy = new ArrayDeque<Object>(this.mLastLdcs);
                Object target = reflectionMethod.getMember(DependencyFinderVisitor.this.mGraph, stackCopy);
                if (target != null) {
                    if (reflectionMethod == ReflectionMethod.CLASS_FOR_NAME) {
                        DependencyFinderVisitor.this.handleDependency(this.mMethod, target, DependencyType.REQUIRED_CODE_REFERENCE_REFLECTION);
                    } else {
                        DependencyFinderVisitor.this.handleUnresolvedReference(new PostProcessingData.UnresolvedReference(this.mMethod, target, false, DependencyType.REQUIRED_CODE_REFERENCE_REFLECTION));
                    }
                }
            }
            this.mLastLdcs.clear();
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            String className = DependencyFinderVisitor.getClassName(desc);
            if (className != null && !AbstractShrinker.isSdkPackage(className)) {
                DependencyFinderVisitor.this.handleDependency(this.mMethod, DependencyFinderVisitor.this.mGraph.getClassReference(className), DependencyType.REQUIRED_CODE_REFERENCE);
            }
            this.mLastLdcs.clear();
            super.visitMultiANewArrayInsn(desc, dims);
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            if (type != null && !AbstractShrinker.isSdkPackage(type)) {
                DependencyFinderVisitor.this.handleDependency(this.mMethod, DependencyFinderVisitor.this.mGraph.getClassReference(type), DependencyType.REQUIRED_CODE_REFERENCE);
            }
            this.mLastLdcs.clear();
            super.visitTryCatchBlock(start, end, handler, type);
        }

        public void visitInsn(int opcode) {
            this.mLastLdcs.clear();
            super.visitInsn(opcode);
        }

        public void visitIntInsn(int opcode, int operand) {
            this.mLastLdcs.clear();
            super.visitIntInsn(opcode, operand);
        }

        public void visitVarInsn(int opcode, int var) {
            this.mLastLdcs.clear();
            super.visitVarInsn(opcode, var);
        }

        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            this.mLastLdcs.clear();
            super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
        }

        public void visitIincInsn(int var, int increment) {
            this.mLastLdcs.clear();
            super.visitIincInsn(var, increment);
        }

        public void visitJumpInsn(int opcode, Label label) {
            this.mLastLdcs.clear();
            super.visitJumpInsn(opcode, label);
        }
    }
}

