/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.incremental.InstantRunVerifierStatus;
import com.android.build.gradle.internal.scope.VariantScope;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;

public class NoChangesVerifierTransform
extends Transform {
    private final VariantScope variantScope;
    private final Set<QualifiedContent.ContentType> inputTypes;
    private final Set<QualifiedContent.Scope> mergeScopes;
    private final InstantRunVerifierStatus failureStatus;
    private final boolean abortBuild;

    public NoChangesVerifierTransform(VariantScope variantScope, Set<QualifiedContent.ContentType> inputTypes, Set<QualifiedContent.Scope> mergeScopes, InstantRunVerifierStatus failureStatus, boolean abortBuild) {
        this.variantScope = variantScope;
        this.inputTypes = inputTypes;
        this.mergeScopes = mergeScopes;
        this.failureStatus = failureStatus;
        this.abortBuild = abortBuild;
    }

    public String getName() {
        return "javaResourcesVerifier";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return this.inputTypes;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return ImmutableSet.of();
    }

    public Set<QualifiedContent.Scope> getReferencedScopes() {
        return this.mergeScopes;
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(TransformInvocation transformInvocation) throws TransformException, InterruptedException, IOException {
        if (NoChangesVerifierTransform.hasChangedInputs(transformInvocation.getReferencedInputs())) {
            this.variantScope.getInstantRunBuildContext().setVerifierResult(this.failureStatus);
            if (this.abortBuild) {
                this.variantScope.getInstantRunBuildContext().abort();
            }
        }
    }

    private static boolean hasChangedInputs(Collection<TransformInput> inputs) {
        for (TransformInput input : inputs) {
            for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
                if (directoryInput.getChangedFiles().isEmpty()) continue;
                return true;
            }
            for (JarInput jarInput : input.getJarInputs()) {
                if (jarInput.getStatus() == Status.NOTCHANGED) continue;
                return true;
            }
        }
        return false;
    }
}

