/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.incremental.IncrementalChangeVisitor;
import com.android.build.gradle.internal.incremental.IncrementalSupportVisitor;
import com.android.build.gradle.internal.incremental.IncrementalVisitor;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.transforms.ChangeRecords;
import com.android.build.gradle.internal.transforms.InstantRunBuildType;
import com.android.ide.common.util.UrlClassLoaderUtil;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.logging.Logging;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public class InstantRunTransform
extends Transform {
    protected static final ILogger LOGGER = new LoggerWrapper(Logging.getLogger(InstantRunTransform.class));
    private final ChangeRecords generatedClasses2Files = new ChangeRecords();
    private final ChangeRecords generatedClasses3Files = new ChangeRecords();
    private final ImmutableList.Builder<String> generatedClasses3Names = ImmutableList.builder();
    private final VariantScope variantScope;

    public InstantRunTransform(VariantScope variantScope) {
        this.variantScope = variantScope;
    }

    public String getName() {
        return "instantRun";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        return ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES, (Object)((Object)ExtendedContentType.CLASSES_ENHANCED));
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROJECT, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.SUB_PROJECTS});
    }

    public Set<QualifiedContent.Scope> getReferencedScopes() {
        return Sets.immutableEnumSet((Enum)QualifiedContent.Scope.EXTERNAL_LIBRARIES, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.PROJECT_LOCAL_DEPS, QualifiedContent.Scope.SUB_PROJECTS_LOCAL_DEPS, QualifiedContent.Scope.PROVIDED_ONLY});
    }

    public boolean isIncremental() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(TransformInvocation invocation) throws IOException, TransformException, InterruptedException {
        TransformOutputProvider outputProvider = invocation.getOutputProvider();
        if (outputProvider == null) {
            throw new IllegalStateException("InstantRunTransform called with null output");
        }
        List<URL> referencedInputUrls = this.getAllClassesLocations(invocation.getInputs(), invocation.getReferencedInputs());
        URLClassLoader urlClassLoader = new URLClassLoader(referencedInputUrls.toArray(new URL[referencedInputUrls.size()]), null){

            @Override
            public URL getResource(String name) {
                return this.findResource(name);
            }
        };
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            this.variantScope.getInstantRunBuildContext().startRecording(InstantRunBuildContext.TaskType.INSTANT_RUN_TRANSFORM);
            Thread.currentThread().setContextClassLoader(urlClassLoader);
            File classesTwoOutput = outputProvider.getContentLocation("main", TransformManager.CONTENT_CLASS, this.getScopes(), Format.DIRECTORY);
            File classesThreeOutput = outputProvider.getContentLocation("enhanced", (Set)ImmutableSet.of((Object)((Object)ExtendedContentType.CLASSES_ENHANCED)), this.getScopes(), Format.DIRECTORY);
            for (TransformInput input : invocation.getInputs()) {
                for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
                    File inputDir = directoryInput.getFile();
                    if (invocation.isIncremental()) {
                        block13: for (Map.Entry entry : directoryInput.getChangedFiles().entrySet()) {
                            File inputFile = (File)entry.getKey();
                            if (!inputFile.getName().endsWith(".class")) continue;
                            switch ((Status)entry.getValue()) {
                                case ADDED: {
                                    this.transformToClasses2Format(inputDir, inputFile, classesTwoOutput, Status.ADDED, RecordingPolicy.RECORD);
                                    continue block13;
                                }
                                case REMOVED: {
                                    File outputFile = InstantRunTransform.deleteOutputFile(IncrementalSupportVisitor.VISITOR_BUILDER, inputDir, inputFile, classesTwoOutput);
                                    if (outputFile != null) {
                                        this.generatedClasses2Files.add(Status.REMOVED, outputFile.getAbsolutePath());
                                    }
                                    InstantRunTransform.deleteOutputFile(IncrementalChangeVisitor.VISITOR_BUILDER, inputDir, inputFile, classesThreeOutput);
                                    continue block13;
                                }
                                case CHANGED: {
                                    this.transformToClasses2Format(inputDir, inputFile, classesTwoOutput, Status.CHANGED, RecordingPolicy.RECORD);
                                    this.transformToClasses3Format(inputDir, inputFile, classesThreeOutput);
                                    continue block13;
                                }
                                case NOTCHANGED: {
                                    continue block13;
                                }
                            }
                            throw new IllegalStateException("Unhandled file status " + entry.getValue());
                        }
                        continue;
                    }
                    for (File file : Files.fileTreeTraverser().breadthFirstTraversal((Object)inputDir)) {
                        if (file.isDirectory()) continue;
                        try {
                            this.transformToClasses2Format(inputDir, file, classesTwoOutput, Status.ADDED, RecordingPolicy.RECORD);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Exception while preparing " + file.getAbsolutePath());
                        }
                    }
                    File incremental = InstantRunBuildType.RESTART.getIncrementalChangesFile(this.variantScope);
                    if (!incremental.exists() || incremental.delete()) continue;
                    LOGGER.warning("Cannot delete " + incremental, new Object[0]);
                }
            }
            this.wrapUpOutputs(classesTwoOutput, classesThreeOutput);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
            UrlClassLoaderUtil.attemptToClose((URLClassLoader)urlClassLoader);
            this.variantScope.getInstantRunBuildContext().stopRecording(InstantRunBuildContext.TaskType.INSTANT_RUN_TRANSFORM);
        }
    }

    protected void wrapUpOutputs(File classes2Folder, File classes3Folder) throws IOException {
        File incremental;
        ImmutableList generatedClassNames = this.generatedClasses3Names.build();
        if (!generatedClassNames.isEmpty()) {
            File patchFile = InstantRunTransform.writePatchFileContents((ImmutableList<String>)generatedClassNames, classes3Folder);
            this.generatedClasses3Files.add(Status.CHANGED, patchFile.getAbsolutePath());
        }
        if ((incremental = InstantRunBuildType.RESTART.getIncrementalChangesFile(this.variantScope)).exists()) {
            ChangeRecords previousIterationChanges = ChangeRecords.load(incremental);
            InstantRunTransform.merge(this.generatedClasses2Files, previousIterationChanges);
        }
        this.generatedClasses2Files.write(InstantRunBuildType.RESTART.getIncrementalChangesFile(this.variantScope));
        this.generatedClasses3Files.write(InstantRunBuildType.RELOAD.getIncrementalChangesFile(this.variantScope));
    }

    static void merge(ChangeRecords changeRecords, ChangeRecords pastIterationRecords) {
        Set<String> deletedFiles = changeRecords.getFilesForStatus(Status.REMOVED);
        for (Map.Entry<String, Status> record : pastIterationRecords.records.entrySet()) {
            if (record.getValue() == Status.REMOVED) {
                if (changeRecords.getChangeFor(record.getKey()) != null) continue;
                changeRecords.add(record.getValue(), record.getKey());
                continue;
            }
            if (deletedFiles.contains(record.getKey())) continue;
            changeRecords.add(record.getValue(), record.getKey());
        }
    }

    private List<URL> getAllClassesLocations(Collection<TransformInput> inputs, Collection<TransformInput> referencedInputs) throws MalformedURLException {
        ArrayList<URL> referencedInputUrls = new ArrayList<URL>();
        for (File file : this.variantScope.getGlobalScope().getAndroidBuilder().getBootClasspath(true)) {
            referencedInputUrls.add(file.toURI().toURL());
        }
        for (TransformInput referencedInput : referencedInputs) {
            InstantRunTransform.addAllClassLocations(referencedInput, referencedInputUrls);
        }
        for (TransformInput input : inputs) {
            InstantRunTransform.addAllClassLocations(input, referencedInputUrls);
        }
        return referencedInputUrls;
    }

    private static void addAllClassLocations(TransformInput transformInput, List<URL> into) throws MalformedURLException {
        for (DirectoryInput directoryInput : transformInput.getDirectoryInputs()) {
            into.add(directoryInput.getFile().toURI().toURL());
        }
        for (JarInput jarInput : transformInput.getJarInputs()) {
            into.add(jarInput.getFile().toURI().toURL());
        }
    }

    protected void transformToClasses2Format(File inputDir, File inputFile, File outputDir, Status change, RecordingPolicy recordingPolicy) throws IOException {
        File outputFile;
        if (inputFile.getPath().endsWith(".class") && (outputFile = IncrementalVisitor.instrumentClass(inputDir, inputFile, outputDir, IncrementalSupportVisitor.VISITOR_BUILDER)) != null && recordingPolicy == RecordingPolicy.RECORD) {
            this.generatedClasses2Files.add(change, outputFile.getAbsolutePath());
        }
    }

    private static File deleteOutputFile(IncrementalVisitor.VisitorBuilder visitorBuilder, File inputDir, File inputFile, File outputDir) {
        String inputPath = FileUtils.relativePossiblyNonExistingPath((File)inputFile, (File)inputDir);
        String outputPath = visitorBuilder.getMangledRelativeClassFilePath(inputPath);
        File outputFile = new File(outputDir, outputPath);
        if (outputFile.exists()) {
            try {
                FileUtils.delete((File)outputFile);
            }
            catch (IOException e) {
                LOGGER.warning("Cannot delete %1$s file.\nCause: %2$s", new Object[]{outputFile, Throwables.getStackTraceAsString((Throwable)e)});
            }
            return outputFile;
        }
        return null;
    }

    protected void transformToClasses3Format(File inputDir, File inputFile, File outputDir) throws IOException {
        File outputFile = IncrementalVisitor.instrumentClass(inputDir, inputFile, outputDir, IncrementalChangeVisitor.VISITOR_BUILDER);
        if (outputFile == null) {
            return;
        }
        this.generatedClasses3Names.add((Object)inputFile.getAbsolutePath().substring(inputDir.getAbsolutePath().length() + 1, inputFile.getAbsolutePath().length() - ".class".length()).replace(File.separatorChar, '.'));
        this.generatedClasses3Files.add(Status.CHANGED, outputFile.getAbsolutePath());
    }

    private static File writePatchFileContents(ImmutableList<String> patchFileContents, File outputDir) {
        ClassWriter cw = new ClassWriter(0);
        cw.visit(50, 33, "com/android/tools/fd/runtime/AppPatchesLoaderImpl", null, "com/android/tools/fd/runtime/AbstractPatchesLoaderImpl", null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "com/android/tools/fd/runtime/AbstractPatchesLoaderImpl", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getPatchedClasses", "()[Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitIntInsn(16, patchFileContents.size());
        mv.visitTypeInsn(189, "java/lang/String");
        for (int index = 0; index < patchFileContents.size(); ++index) {
            mv.visitInsn(89);
            mv.visitIntInsn(16, index);
            mv.visitLdcInsn(patchFileContents.get(index));
            mv.visitInsn(83);
        }
        mv.visitInsn(176);
        mv.visitMaxs(4, 1);
        mv.visitEnd();
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        File outputFile = new File(outputDir, "com/android/tools/fd/runtime/AppPatchesLoaderImpl.class");
        try {
            Files.createParentDirs((File)outputFile);
            Files.write((byte[])classBytes, (File)outputFile);
            return outputFile;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    static enum RecordingPolicy {
        RECORD,
        DO_NOT_RECORD;

    }
}

