/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import com.android.build.api.transform.Context;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.SecondaryInput;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.gradle.internal.pipeline.IncrementalTransformInput;
import com.android.build.gradle.internal.pipeline.IntermediateStream;
import com.android.build.gradle.internal.pipeline.StreamBasedTask;
import com.android.build.gradle.internal.pipeline.TransformInvocationBuilder;
import com.android.build.gradle.internal.pipeline.TransformStream;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.builder.profile.ExecutionType;
import com.android.builder.profile.Recorder;
import com.android.builder.profile.ThreadRecorder;
import com.android.ide.common.util.ReferenceHolder;
import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectories;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;

@ParallelizableTask
public class TransformTask
extends StreamBasedTask
implements Context {
    private Transform transform;
    Collection<SecondaryFile> secondaryFiles = null;

    public Transform getTransform() {
        return this.transform;
    }

    @InputFiles
    public Collection<File> getOtherFileInputs() {
        ImmutableList.Builder otherFileInputs = ImmutableList.builder();
        otherFileInputs.addAll(Iterables.transform((Iterable)this.transform.getSecondaryFiles(), (Function)new Function<SecondaryFile, File>(){

            public File apply(SecondaryFile input) {
                return input.getFile();
            }
        }));
        otherFileInputs.addAll((Iterable)this.transform.getSecondaryFileInputs());
        return otherFileInputs.build();
    }

    @OutputFiles
    public Collection<File> getOtherFileOutputs() {
        return this.transform.getSecondaryFileOutputs();
    }

    @OutputDirectories
    public Collection<File> getOtherFolderOutputs() {
        return this.transform.getSecondaryDirectoryOutputs();
    }

    @Input
    Map<String, Object> getOtherInputs() {
        return this.transform.getParameterInputs();
    }

    @TaskAction
    void transform(final IncrementalTaskInputs incrementalTaskInputs) throws IOException, TransformException, InterruptedException {
        final ReferenceHolder consumedInputs = ReferenceHolder.empty();
        final ReferenceHolder referencedInputs = ReferenceHolder.empty();
        final ReferenceHolder isIncremental = ReferenceHolder.empty();
        final ReferenceHolder changedSecondaryInputs = ReferenceHolder.empty();
        ThreadRecorder.get().record(ExecutionType.TASK_TRANSFORM_PREPARATION, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() throws Exception {
                List incReferencedInputs;
                List incInputs;
                isIncremental.setValue((Object)(TransformTask.this.transform.isIncremental() && incrementalTaskInputs.isIncremental() ? 1 : 0));
                HashMap changedMap = Maps.newHashMap();
                HashSet removedFiles = Sets.newHashSet();
                if (((Boolean)isIncremental.getValue()).booleanValue()) {
                    TransformTask.gatherChangedFiles(incrementalTaskInputs, changedMap, removedFiles);
                    isIncremental.setValue((Object)TransformTask.this.checkSecondaryFiles(changedMap, removedFiles));
                }
                if (((Boolean)isIncremental.getValue()).booleanValue() && ((Boolean)isIncremental.setValue((Object)TransformTask.this.updateIncrementalInputsWithChangedFiles(incInputs = TransformTask.createIncrementalInputs(TransformTask.this.consumedInputStreams), incReferencedInputs = TransformTask.createIncrementalInputs(TransformTask.this.referencedInputStreams), changedMap, removedFiles))).booleanValue()) {
                    consumedInputs.setValue((Object)TransformTask.convertToImmutable(incInputs));
                    referencedInputs.setValue((Object)TransformTask.convertToImmutable(incReferencedInputs));
                }
                if (!((Boolean)isIncremental.getValue()).booleanValue()) {
                    consumedInputs.setValue((Object)TransformTask.computeNonIncTransformInput(TransformTask.this.consumedInputStreams));
                    referencedInputs.setValue((Object)TransformTask.computeNonIncTransformInput(TransformTask.this.referencedInputStreams));
                    changedSecondaryInputs.setValue((Object)ImmutableList.of());
                } else {
                    changedSecondaryInputs.setValue((Object)TransformTask.this.gatherSecondaryInputChanges(changedMap, removedFiles));
                }
                return null;
            }
        }, new Recorder.Property[]{new Recorder.Property("project", this.getProject().getName()), new Recorder.Property("transform", this.transform.getName()), new Recorder.Property("incremental", Boolean.toString(this.transform.isIncremental()))});
        ThreadRecorder.get().record(ExecutionType.TASK_TRANSFORM, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() throws Exception {
                TransformTask.this.transform.transform(new TransformInvocationBuilder(TransformTask.this).addInputs((Collection)consumedInputs.getValue()).addReferencedInputs((Collection)referencedInputs.getValue()).addSecondaryInputs((Collection)changedSecondaryInputs.getValue()).addOutputProvider(TransformTask.this.outputStream != null ? TransformTask.this.outputStream.asOutput() : null).setIncrementalMode((Boolean)isIncremental.getValue()).build());
                return null;
            }
        }, new Recorder.Property[]{new Recorder.Property("project", this.getProject().getName()), new Recorder.Property("transform", this.transform.getName()), new Recorder.Property("incremental", Boolean.toString(this.transform.isIncremental()))});
    }

    private Collection<SecondaryInput> gatherSecondaryInputChanges(Map<File, Status> changedMap, Set<File> removedFiles) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (final SecondaryFile secondaryFile : this.getAllSecondaryInputs()) {
            File file = secondaryFile.getFile();
            final Status status = changedMap.containsKey(file) ? changedMap.get(file) : (removedFiles.contains(file) ? Status.REMOVED : Status.NOTCHANGED);
            builder.add((Object)new SecondaryInput(){

                public SecondaryFile getSecondaryInput() {
                    return secondaryFile;
                }

                public Status getStatus() {
                    return status;
                }
            });
        }
        return builder.build();
    }

    private static List<TransformInput> computeNonIncTransformInput(Collection<TransformStream> streams) {
        ArrayList inputs = Lists.newArrayListWithCapacity((int)streams.size());
        for (TransformStream stream : streams) {
            inputs.add(stream.asNonIncrementalInput());
        }
        return inputs;
    }

    private static List<IncrementalTransformInput> createIncrementalInputs(Collection<TransformStream> streams) {
        ArrayList list = Lists.newArrayListWithCapacity((int)streams.size());
        for (TransformStream stream : streams) {
            list.add(stream.asIncrementalInput());
        }
        return list;
    }

    private synchronized Collection<SecondaryFile> getAllSecondaryInputs() {
        if (this.secondaryFiles == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll((Iterable)this.transform.getSecondaryFiles());
            builder.addAll((Iterable)Collections2.transform((Collection)this.transform.getSecondaryFileInputs(), (Function)new Function<File, SecondaryFile>(){

                public SecondaryFile apply(File input) {
                    return new SecondaryFile(input, false);
                }
            }));
            this.secondaryFiles = builder.build();
        }
        return this.secondaryFiles;
    }

    private static void gatherChangedFiles(IncrementalTaskInputs incrementalTaskInputs, final Map<File, Status> changedFileMap, final Set<File> removedFiles) {
        incrementalTaskInputs.outOfDate((Action)new Action<InputFileDetails>(){

            public void execute(InputFileDetails inputFileDetails) {
                if (inputFileDetails.isAdded()) {
                    changedFileMap.put(inputFileDetails.getFile(), Status.ADDED);
                } else if (inputFileDetails.isModified()) {
                    changedFileMap.put(inputFileDetails.getFile(), Status.CHANGED);
                }
            }
        });
        incrementalTaskInputs.removed((Action)new Action<InputFileDetails>(){

            public void execute(InputFileDetails inputFileDetails) {
                removedFiles.add(inputFileDetails.getFile());
            }
        });
    }

    private boolean checkSecondaryFiles(Map<File, Status> changedMap, Set<File> removedFiles) {
        for (SecondaryFile secondaryFile : this.getAllSecondaryInputs()) {
            File file = secondaryFile.getFile();
            if (!changedMap.containsKey(file) && !removedFiles.contains(file) || secondaryFile.supportsIncrementalBuild()) continue;
            return false;
        }
        return true;
    }

    private boolean isSecondaryFile(File file) {
        for (SecondaryFile secondaryFile : this.getAllSecondaryInputs()) {
            if (!secondaryFile.getFile().equals(file)) continue;
            return true;
        }
        return false;
    }

    private boolean updateIncrementalInputsWithChangedFiles(List<IncrementalTransformInput> consumedInputs, List<IncrementalTransformInput> referencedInputs, Map<File, Status> changedFilesMap, Set<File> removedFiles) {
        ArrayList iterators = Lists.newArrayListWithCapacity((int)2);
        Splitter splitter = Splitter.on((char)File.separatorChar);
        for (File file : removedFiles) {
            ArrayList removedFileSegments = Lists.newArrayList((Iterable)splitter.split((CharSequence)file.getAbsolutePath()));
            Iterator<IncrementalTransformInput> iterator = TransformTask.getConcatIterator(consumedInputs, referencedInputs, iterators);
            boolean found = false;
            while (iterator.hasNext()) {
                IncrementalTransformInput next = iterator.next();
                if (!next.checkRemovedJarFile(file, removedFileSegments) && !next.checkRemovedFolderFile(file, removedFileSegments)) continue;
                found = true;
                break;
            }
            if (found || this.isSecondaryFile(file)) continue;
            return false;
        }
        for (Map.Entry entry : changedFilesMap.entrySet()) {
            File changedFile = (File)entry.getKey();
            Status changedStatus = (Status)entry.getValue();
            Iterator<IncrementalTransformInput> iterator = TransformTask.getConcatIterator(consumedInputs, referencedInputs, iterators);
            boolean found = false;
            while (iterator.hasNext()) {
                if (!iterator.next().checkForJar(changedFile, changedStatus)) continue;
                found = true;
                break;
            }
            if (found) continue;
            iterator = TransformTask.getConcatIterator(consumedInputs, referencedInputs, iterators);
            ArrayList changedSegments = Lists.newArrayList((Iterable)splitter.split((CharSequence)changedFile.getAbsolutePath()));
            while (iterator.hasNext() && !iterator.next().checkForFolder(changedFile, changedSegments, changedStatus)) {
            }
        }
        return true;
    }

    private static Iterator<IncrementalTransformInput> getConcatIterator(List<IncrementalTransformInput> consumedInputs, List<IncrementalTransformInput> referencedInputs, List<Iterator<IncrementalTransformInput>> iterators) {
        iterators.clear();
        iterators.add(consumedInputs.iterator());
        iterators.add(referencedInputs.iterator());
        return Iterators.concat(iterators.iterator());
    }

    private static List<TransformInput> convertToImmutable(List<IncrementalTransformInput> inputs) {
        ArrayList immutableInputs = Lists.newArrayListWithCapacity((int)inputs.size());
        for (IncrementalTransformInput input : inputs) {
            immutableInputs.add(input.asImmutable());
        }
        return immutableInputs;
    }

    public static class ConfigAction<T extends Transform>
    implements TaskConfigAction<TransformTask> {
        private final String variantName;
        private final String taskName;
        private final T transform;
        private Collection<TransformStream> consumedInputStreams;
        private Collection<TransformStream> referencedInputStreams;
        private IntermediateStream outputStream;
        private final ConfigActionCallback<T> configActionCallback;

        ConfigAction(String variantName, String taskName, T transform, Collection<TransformStream> consumedInputStreams, Collection<TransformStream> referencedInputStreams, IntermediateStream outputStream, ConfigActionCallback<T> configActionCallback) {
            this.variantName = variantName;
            this.taskName = taskName;
            this.transform = transform;
            this.consumedInputStreams = consumedInputStreams;
            this.referencedInputStreams = referencedInputStreams;
            this.outputStream = outputStream;
            this.configActionCallback = configActionCallback;
        }

        @Override
        public String getName() {
            return this.taskName;
        }

        @Override
        public Class<TransformTask> getType() {
            return TransformTask.class;
        }

        @Override
        public void execute(TransformTask task) {
            task.transform = this.transform;
            task.consumedInputStreams = this.consumedInputStreams;
            task.referencedInputStreams = this.referencedInputStreams;
            task.outputStream = this.outputStream;
            task.setVariantName(this.variantName);
            if (this.configActionCallback != null) {
                this.configActionCallback.callback(this.transform, task);
            }
        }
    }

    public static interface ConfigActionCallback<T extends Transform> {
        public void callback(T var1, TransformTask var2);
    }
}

