/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.InstantRunPatchingPolicy;
import com.android.build.gradle.internal.incremental.InstantRunVerifierStatus;
import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.sdklib.AndroidVersion;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InstantRunBuildContext {
    static final String TAG_INSTANT_RUN = "instant-run";
    static final String TAG_BUILD = "build";
    static final String TAG_ARTIFACT = "artifact";
    static final String TAG_TASK = "task";
    static final String ATTR_NAME = "name";
    static final String ATTR_DURATION = "duration";
    static final String ATTR_TIMESTAMP = "timestamp";
    static final String ATTR_VERIFIER = "verifier";
    static final String ATTR_TYPE = "type";
    static final String ATTR_LOCATION = "location";
    static final String ATTR_API_LEVEL = "api-level";
    static final String ATTR_DENSITY = "density";
    static final String ATTR_FORMAT = "format";
    static final String ATTR_ABI = "abi";
    static final String ATTR_TOKEN = "token";
    static final String CURRENT_FORMAT = "7";
    private final long[] taskStartTime = new long[TaskType.values().length];
    private final long[] taskDurationInMs = new long[TaskType.values().length];
    private InstantRunPatchingPolicy patchingPolicy;
    private AndroidVersion apiLevel = AndroidVersion.DEFAULT;
    private String density = null;
    private String abi = null;
    private final Build currentBuild = new Build(System.nanoTime(), (Optional<InstantRunVerifierStatus>)Optional.absent());
    private final TreeMap<Long, Build> previousBuilds = new TreeMap();
    private File tmpBuildInfo = null;
    private boolean isInstantRunMode = false;
    private volatile boolean isAborted = false;
    private final AtomicLong token = new AtomicLong(0L);

    public void setInstantRunMode(boolean instantRunMode) {
        this.isInstantRunMode = instantRunMode;
    }

    public boolean isInInstantRunMode() {
        return this.isInstantRunMode;
    }

    public void setTmpBuildInfo(File tmpBuildInfo) {
        this.tmpBuildInfo = tmpBuildInfo;
    }

    public long getBuildId() {
        return this.currentBuild.buildId;
    }

    public void startRecording(TaskType taskType) {
        this.taskStartTime[taskType.ordinal()] = System.currentTimeMillis();
    }

    public long stopRecording(TaskType taskType) {
        long duration;
        this.taskDurationInMs[taskType.ordinal()] = duration = System.currentTimeMillis() - this.taskStartTime[taskType.ordinal()];
        return duration;
    }

    public void setVerifierResult(InstantRunVerifierStatus verifierStatus) {
        if (!this.currentBuild.verifierStatus.isPresent() || this.currentBuild.getVerifierStatus().get() == InstantRunVerifierStatus.COMPATIBLE) {
            this.currentBuild.verifierStatus = Optional.of((Object)((Object)verifierStatus));
        }
    }

    public boolean hasPassedVerification() {
        return !this.currentBuild.verifierStatus.isPresent() || this.currentBuild.verifierStatus.get() == InstantRunVerifierStatus.COMPATIBLE;
    }

    public void setApiLevel(AndroidVersion apiLevel, String coldswapMode, String targetAbi) {
        this.apiLevel = apiLevel;
        this.patchingPolicy = InstantRunPatchingPolicy.getPatchingPolicy(apiLevel, coldswapMode, targetAbi);
        this.abi = targetAbi;
    }

    public AndroidVersion getApiLevel() {
        return this.apiLevel;
    }

    public String getDensity() {
        return this.density;
    }

    public void setDensity(String density) {
        this.density = density;
    }

    public InstantRunPatchingPolicy getPatchingPolicy() {
        return this.patchingPolicy;
    }

    public synchronized void addChangedFile(FileType fileType, File file) throws IOException {
        if (this.patchingPolicy == null) {
            return;
        }
        for (Artifact artifact : this.currentBuild.artifacts) {
            if (artifact.getType() != fileType || !artifact.getLocation().getAbsolutePath().equals(file.getAbsolutePath())) continue;
            return;
        }
        if (fileType != FileType.RELOAD_DEX && fileType != FileType.MAIN && fileType != FileType.RESOURCES) {
            switch (this.patchingPolicy) {
                case PRE_LOLLIPOP: {
                    if (fileType == FileType.RESTART_DEX) break;
                    return;
                }
                case MULTI_DEX: {
                    if (fileType == FileType.DEX) break;
                    return;
                }
                case MULTI_APK: {
                    if (fileType != FileType.SPLIT) {
                        return;
                    }
                    Artifact splitMain = this.currentBuild.getArtifactForType(FileType.SPLIT_MAIN);
                    if (splitMain != null || (splitMain = this.getPastBuildsArtifactForType(FileType.SPLIT_MAIN)) == null) break;
                    this.currentBuild.artifacts.add(splitMain);
                }
            }
        }
        if (fileType == FileType.MAIN) {
            Artifact resourcesApFile;
            Artifact previousArtifact;
            if (this.patchingPolicy == InstantRunPatchingPolicy.MULTI_APK) {
                fileType = FileType.SPLIT_MAIN;
            }
            if ((previousArtifact = this.currentBuild.getArtifactForType(fileType)) != null) {
                this.currentBuild.artifacts.remove(previousArtifact);
            }
            if (this.patchingPolicy == InstantRunPatchingPolicy.MULTI_DEX) {
                this.currentBuild.artifacts.clear();
            }
            if ((resourcesApFile = this.currentBuild.getArtifactForType(FileType.RESOURCES)) != null) {
                this.currentBuild.artifacts.remove(resourcesApFile);
            }
        }
        this.currentBuild.artifacts.add(new Artifact(fileType, file));
        try {
            this.writeTmpBuildInfo();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
    }

    public void abort() {
        this.isAborted = true;
    }

    public Build getLastBuild() {
        return this.previousBuilds.isEmpty() ? null : this.previousBuilds.lastEntry().getValue();
    }

    public Artifact getPastBuildsArtifactForType(FileType fileType) {
        for (Build build : this.previousBuilds.values()) {
            Artifact artifact = build.getArtifactForType(fileType);
            if (artifact == null) continue;
            return artifact;
        }
        return null;
    }

    public long getSecretToken() {
        return this.token.get();
    }

    public void setSecretToken(long token) {
        this.token.set(token);
    }

    @VisibleForTesting
    Collection<Build> getPreviousBuilds() {
        return this.previousBuilds.values();
    }

    private void purge() {
        boolean foundColdRestart = false;
        HashSet<String> splitFilesAlreadyFound = new HashSet<String>();
        Long initialFullBuild = this.previousBuilds.firstKey();
        for (Long aBuildId : new ArrayList<Long>(this.previousBuilds.descendingKeySet())) {
            Artifact resourceApArtifact;
            Build previousBuild = this.previousBuilds.get(aBuildId);
            if (previousBuild.buildId == initialFullBuild) continue;
            if (previousBuild.verifierStatus.isPresent()) {
                if (previousBuild.verifierStatus.get() == InstantRunVerifierStatus.COMPATIBLE) {
                    if (foundColdRestart) {
                        this.previousBuilds.remove(aBuildId);
                        continue;
                    }
                } else {
                    foundColdRestart = true;
                }
            } else {
                foundColdRestart = previousBuild.hasCodeArtifact();
            }
            if (foundColdRestart && this.patchingPolicy == InstantRunPatchingPolicy.MULTI_APK && (resourceApArtifact = previousBuild.getArtifactForType(FileType.RESOURCES)) != null) {
                previousBuild.artifacts.remove(resourceApArtifact);
            }
            for (Artifact artifact : new ArrayList(previousBuild.artifacts)) {
                if (!artifact.isAccumulative()) continue;
                if (splitFilesAlreadyFound.contains(artifact.getLocation().getAbsolutePath())) {
                    previousBuild.artifacts.remove(artifact);
                    continue;
                }
                splitFilesAlreadyFound.add(artifact.getLocation().getAbsolutePath());
            }
        }
        for (Long aBuildId : new ArrayList<Long>(this.previousBuilds.descendingKeySet())) {
            Build aBuild = this.previousBuilds.get(aBuildId);
            if (!aBuild.artifacts.isEmpty() || aBuild.buildId == this.currentBuild.buildId) continue;
            this.previousBuilds.remove(aBuildId);
        }
    }

    public void loadFromXmlFile(File persistedState) throws IOException, ParserConfigurationException, SAXException {
        if (!persistedState.exists()) {
            return;
        }
        this.loadFromDocument(XmlUtils.parseUtfXmlFile((File)persistedState, (boolean)false));
    }

    public void loadFromXml(String persistedState) throws IOException, SAXException, ParserConfigurationException {
        this.loadFromDocument(XmlUtils.parseDocument((String)persistedState, (boolean)false));
    }

    private void loadFromDocument(Document document) {
        Element instantRun = document.getDocumentElement();
        String tokenString = instantRun.getAttribute(ATTR_TOKEN);
        if (!Strings.isNullOrEmpty((String)tokenString)) {
            this.token.set(Long.parseLong(tokenString));
        }
        Build lastBuild = Build.fromXml(instantRun);
        this.previousBuilds.put(lastBuild.buildId, lastBuild);
        NodeList buildNodes = instantRun.getChildNodes();
        for (int i = 0; i < buildNodes.getLength(); ++i) {
            Node buildNode = buildNodes.item(i);
            if (!buildNode.getNodeName().equals(TAG_BUILD)) continue;
            Build build = Build.fromXml(buildNode);
            this.previousBuilds.put(build.buildId, build);
        }
    }

    public void mergeFromFile(File tmpBuildInfoFile) throws IOException, SAXException, ParserConfigurationException {
        if (!tmpBuildInfoFile.exists()) {
            return;
        }
        this.mergeFrom(XmlUtils.parseUtfXmlFile((File)tmpBuildInfoFile, (boolean)false));
    }

    public void mergeFrom(String tmpBuildInfo) throws IOException, SAXException, ParserConfigurationException {
        this.mergeFrom(XmlUtils.parseDocument((String)tmpBuildInfo, (boolean)false));
    }

    private void mergeFrom(Document document) {
        Element instantRun = document.getDocumentElement();
        Build lastBuild = Build.fromXml(instantRun);
        this.currentBuild.artifacts.addAll(lastBuild.artifacts);
    }

    public void close(PersistenceMode persistenceMode) {
        if (this.isAborted && (!this.currentBuild.getVerifierStatus().isPresent() || this.currentBuild.getVerifierStatus().get() != InstantRunVerifierStatus.BINARY_MANIFEST_FILE_CHANGE || persistenceMode != PersistenceMode.FULL_BUILD)) {
            this.currentBuild.artifacts.clear();
        }
        this.previousBuilds.put(this.currentBuild.buildId, this.currentBuild);
        this.purge();
    }

    public void close() {
        this.close(PersistenceMode.FULL_BUILD);
    }

    public String toXml() throws ParserConfigurationException {
        return this.toXml(PersistenceMode.INCREMENTAL_BUILD);
    }

    public String toXml(PersistenceMode persistenceMode) throws ParserConfigurationException {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        this.toXml(document, persistenceMode);
        return XmlPrettyPrinter.prettyPrint((Node)document, (boolean)true);
    }

    private Element toXml(Document document, PersistenceMode persistenceMode) {
        Element instantRun = document.createElement(TAG_INSTANT_RUN);
        document.appendChild(instantRun);
        for (TaskType taskType : TaskType.values()) {
            Element taskTypeNode = document.createElement(TAG_TASK);
            taskTypeNode.setAttribute(ATTR_NAME, (String)CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.LOWER_HYPHEN).convert((Object)taskType.name()));
            taskTypeNode.setAttribute(ATTR_DURATION, String.valueOf(this.taskDurationInMs[taskType.ordinal()]));
            instantRun.appendChild(taskTypeNode);
        }
        if (persistenceMode == PersistenceMode.FULL_BUILD) {
            this.currentBuild.verifierStatus = Optional.absent();
        }
        this.currentBuild.toXml(document, instantRun);
        instantRun.setAttribute(ATTR_API_LEVEL, String.valueOf(this.apiLevel.getApiLevel()));
        if (this.density != null) {
            instantRun.setAttribute(ATTR_DENSITY, this.density);
        }
        if (this.abi != null) {
            instantRun.setAttribute(ATTR_ABI, this.abi);
        }
        if (this.token != null) {
            instantRun.setAttribute(ATTR_TOKEN, this.token.toString());
        }
        instantRun.setAttribute(ATTR_FORMAT, CURRENT_FORMAT);
        switch (persistenceMode) {
            case FULL_BUILD: {
                if (this.previousBuilds.isEmpty()) break;
                instantRun.appendChild(this.previousBuilds.lastEntry().getValue().toXml(document));
                break;
            }
            case INCREMENTAL_BUILD: {
                for (Build build : this.previousBuilds.values()) {
                    instantRun.appendChild(build.toXml(document));
                }
                break;
            }
            case TEMP_BUILD: {
                break;
            }
            default: {
                throw new RuntimeException("PersistenceMode not handled" + (Object)((Object)persistenceMode));
            }
        }
        return instantRun;
    }

    private void writeTmpBuildInfo() throws ParserConfigurationException, IOException {
        if (this.tmpBuildInfo == null) {
            return;
        }
        Files.createParentDirs((File)this.tmpBuildInfo);
        Files.write((CharSequence)this.toXml(PersistenceMode.TEMP_BUILD), (File)this.tmpBuildInfo, (Charset)Charsets.UTF_8);
    }

    public static enum PersistenceMode {
        FULL_BUILD,
        INCREMENTAL_BUILD,
        TEMP_BUILD;

    }

    public static class Artifact {
        private final FileType fileType;
        private File location;

        public Artifact(FileType fileType, File location) {
            this.fileType = fileType;
            this.location = location;
        }

        public Node toXml(Document document) {
            Element artifact = document.createElement(InstantRunBuildContext.TAG_ARTIFACT);
            artifact.setAttribute(InstantRunBuildContext.ATTR_TYPE, this.fileType.name());
            artifact.setAttribute(InstantRunBuildContext.ATTR_LOCATION, XmlUtils.toXmlAttributeValue((String)this.location.getAbsolutePath()));
            return artifact;
        }

        public static Artifact fromXml(Node artifactNode) {
            NamedNodeMap attributes = artifactNode.getAttributes();
            return new Artifact(FileType.valueOf(attributes.getNamedItem(InstantRunBuildContext.ATTR_TYPE).getNodeValue()), new File(attributes.getNamedItem(InstantRunBuildContext.ATTR_LOCATION).getNodeValue()));
        }

        public File getLocation() {
            return this.location;
        }

        public boolean isAccumulative() {
            return this.fileType == FileType.DEX || this.fileType == FileType.SPLIT || this.fileType == FileType.MAIN || this.fileType == FileType.RESOURCES;
        }

        public void setLocation(File location) {
            this.location = location;
        }

        public FileType getType() {
            return this.fileType;
        }
    }

    public static class Build {
        private final long buildId;
        private Optional<InstantRunVerifierStatus> verifierStatus;
        private final List<Artifact> artifacts = new ArrayList<Artifact>();

        public Build(long buildId, Optional<InstantRunVerifierStatus> verifierStatus) {
            this.buildId = buildId;
            this.verifierStatus = verifierStatus;
        }

        public Artifact getArtifactForType(FileType fileType) {
            for (Artifact artifact : this.artifacts) {
                if (artifact.fileType != fileType) continue;
                return artifact;
            }
            return null;
        }

        private boolean hasCodeArtifact() {
            for (Artifact artifact : this.artifacts) {
                FileType type = artifact.getType();
                if (type != FileType.DEX && type != FileType.SPLIT && type != FileType.MAIN && type != FileType.RESTART_DEX) continue;
                return true;
            }
            return false;
        }

        private Element toXml(Document document) {
            Element build = document.createElement(InstantRunBuildContext.TAG_BUILD);
            this.toXml(document, build);
            return build;
        }

        private void toXml(Document document, Element element) {
            element.setAttribute(InstantRunBuildContext.ATTR_TIMESTAMP, String.valueOf(this.buildId));
            if (this.verifierStatus.isPresent()) {
                element.setAttribute(InstantRunBuildContext.ATTR_VERIFIER, ((InstantRunVerifierStatus)((Object)this.verifierStatus.get())).name());
            }
            for (Artifact artifact : this.artifacts) {
                element.appendChild(artifact.toXml(document));
            }
        }

        public static Build fromXml(Node buildNode) {
            NamedNodeMap attributes = buildNode.getAttributes();
            Node verifierAttribute = attributes.getNamedItem(InstantRunBuildContext.ATTR_VERIFIER);
            Build build = new Build(Long.parseLong(attributes.getNamedItem(InstantRunBuildContext.ATTR_TIMESTAMP).getNodeValue()), (Optional<InstantRunVerifierStatus>)(verifierAttribute != null ? Optional.of((Object)((Object)InstantRunVerifierStatus.valueOf(verifierAttribute.getNodeValue()))) : Optional.absent()));
            NodeList childNodes = buildNode.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node artifactNode = childNodes.item(i);
                if (!artifactNode.getNodeName().equals(InstantRunBuildContext.TAG_ARTIFACT)) continue;
                Artifact artifact = Artifact.fromXml(artifactNode);
                build.artifacts.add(artifact);
            }
            return build;
        }

        public long getBuildId() {
            return this.buildId;
        }

        public List<Artifact> getArtifacts() {
            return this.artifacts;
        }

        public Optional<InstantRunVerifierStatus> getVerifierStatus() {
            return this.verifierStatus;
        }
    }

    public static enum FileType {
        MAIN,
        SPLIT_MAIN,
        RELOAD_DEX,
        RESTART_DEX,
        DEX,
        SPLIT,
        RESOURCES;

    }

    public static enum TaskType {
        JAVAC,
        INSTANT_RUN_DEX,
        INSTANT_RUN_TRANSFORM,
        VERIFIER;

    }
}

