/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle;

import com.android.build.gradle.OptionalCompilationStep;
import com.android.sdklib.AndroidVersion;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.gradle.api.Project;

public class AndroidGradleOptions {
    private static final String PROPERTY_TEST_RUNNER_ARGS = "android.testInstrumentationRunnerArguments.";
    private static final String PROPERTY_THREAD_POOL_SIZE = "android.threadPoolSize";
    private static final String PROPERTY_THREAD_POOL_SIZE_OLD = "com.android.build.threadPoolSize";
    public static final String USE_DEPRECATED_NDK = "android.useDeprecatedNdk";
    private static final String PROPERTY_DISABLE_RESOURCE_VALIDATION = "android.disableResourceValidation";
    private static final String PROPERTY_BENCHMARK_NAME = "com.android.benchmark.name";
    private static final String PROPERTY_BENCHMARK_MODE = "com.android.benchmark.mode";
    public static final String PROPERTY_INCREMENTAL_JAVA_COMPILE = "android.incrementalJavaCompile";
    private static final String PROPERTY_USE_OLD_PACKAGING = "android.useOldPackaging";

    public static Map<String, String> getExtraInstrumentationTestRunnerArgs(Project project) {
        HashMap argsMap = Maps.newHashMap();
        for (Map.Entry entry : project.getProperties().entrySet()) {
            if (!((String)entry.getKey()).startsWith(PROPERTY_TEST_RUNNER_ARGS)) continue;
            String argName = ((String)entry.getKey()).substring(PROPERTY_TEST_RUNNER_ARGS.length());
            String argValue = entry.getValue().toString();
            argsMap.put(argName, argValue);
        }
        return argsMap;
    }

    public static String getBenchmarkName(Project project) {
        return AndroidGradleOptions.getString(project, PROPERTY_BENCHMARK_NAME);
    }

    public static String getBenchmarkMode(Project project) {
        return AndroidGradleOptions.getString(project, PROPERTY_BENCHMARK_MODE);
    }

    public static boolean invokedFromIde(Project project) {
        return AndroidGradleOptions.getBoolean(project, "android.injected.invoked.from.ide");
    }

    public static boolean buildModelOnly(Project project) {
        return AndroidGradleOptions.getBoolean(project, "android.injected.build.model.only");
    }

    public static boolean buildModelOnlyAdvanced(Project project) {
        return AndroidGradleOptions.getBoolean(project, "android.injected.build.model.only.advanced");
    }

    public static boolean useOldPackaging(Project project) {
        return AndroidGradleOptions.getBoolean(project, PROPERTY_USE_OLD_PACKAGING, true);
    }

    public static String getApkLocation(Project project) {
        return AndroidGradleOptions.getString(project, "android.injected.apk.location");
    }

    public static String getBuildTargetDensity(Project project) {
        return AndroidGradleOptions.getString(project, "android.injected.build.density");
    }

    public static String getBuildTargetAbi(Project project) {
        return AndroidGradleOptions.getString(project, "android.injected.build.abi");
    }

    public static AndroidVersion getTargetApiLevel(Project project) {
        String apiVersion = AndroidGradleOptions.getString(project, "android.injected.build.api");
        AndroidVersion version = AndroidVersion.DEFAULT;
        if (apiVersion != null) {
            try {
                version = new AndroidVersion(apiVersion);
            }
            catch (AndroidVersion.AndroidVersionException e) {
                project.getLogger().warn("Wrong build target version passed ", (Throwable)e);
            }
        }
        return version;
    }

    public static String getColdswapMode(Project project) {
        return AndroidGradleOptions.getString(project, "android.injected.coldswap.mode");
    }

    public static boolean useDeprecatedNdk(Project project) {
        return AndroidGradleOptions.getBoolean(project, USE_DEPRECATED_NDK);
    }

    public static Integer getThreadPoolSize(Project project) {
        Integer size = AndroidGradleOptions.getInteger(project, PROPERTY_THREAD_POOL_SIZE);
        if (size == null) {
            size = AndroidGradleOptions.getInteger(project, PROPERTY_THREAD_POOL_SIZE_OLD);
        }
        return size;
    }

    public static SigningOptions getSigningOptions(Project project) {
        String signingStoreFile = AndroidGradleOptions.getString(project, "android.injected.signing.store.file");
        String signingStorePassword = AndroidGradleOptions.getString(project, "android.injected.signing.store.password");
        String signingKeyAlias = AndroidGradleOptions.getString(project, "android.injected.signing.key.alias");
        String signingKeyPassword = AndroidGradleOptions.getString(project, "android.injected.signing.key.password");
        if (signingStoreFile != null && signingStorePassword != null && signingKeyAlias != null && signingKeyPassword != null) {
            String signingStoreType = AndroidGradleOptions.getString(project, "android.injected.signing.store.type");
            return new SigningOptions(signingStoreFile, signingStorePassword, signingKeyAlias, signingKeyPassword, signingStoreType);
        }
        return null;
    }

    public static EnumSet<OptionalCompilationStep> getOptionalCompilationSteps(Project project) {
        String values = AndroidGradleOptions.getString(project, "android.optional.compilation");
        if (values != null) {
            ArrayList<OptionalCompilationStep> optionalCompilationSteps = new ArrayList<OptionalCompilationStep>();
            StringTokenizer st = new StringTokenizer(values, ",");
            while (st.hasMoreElements()) {
                optionalCompilationSteps.add(OptionalCompilationStep.valueOf(st.nextToken()));
            }
            return EnumSet.copyOf(optionalCompilationSteps);
        }
        return EnumSet.noneOf(OptionalCompilationStep.class);
    }

    public static boolean isResourceValidationEnabled(Project project) {
        return !AndroidGradleOptions.getBoolean(project, PROPERTY_DISABLE_RESOURCE_VALIDATION);
    }

    private static String getString(Project project, String propertyName) {
        return project.hasProperty(propertyName) ? (String)project.property(propertyName) : null;
    }

    private static Integer getInteger(Project project, String propertyName) {
        if (project.hasProperty(propertyName)) {
            try {
                return Integer.parseInt(project.property(propertyName).toString());
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Property " + propertyName + " needs to be an integer.");
            }
        }
        return null;
    }

    private static boolean getBoolean(Project project, String propertyName) {
        return AndroidGradleOptions.getBoolean(project, propertyName, false);
    }

    private static boolean getBoolean(Project project, String propertyName, boolean defaultValue) {
        if (project.hasProperty(propertyName)) {
            Object value = project.property(propertyName);
            if (value instanceof String) {
                return Boolean.parseBoolean((String)value);
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
        }
        return defaultValue;
    }

    public static boolean isJavaCompileIncrementalPropertySet(Project project) {
        return project.hasProperty(PROPERTY_INCREMENTAL_JAVA_COMPILE);
    }

    public static class SigningOptions {
        public final String storeFile;
        public final String storePassword;
        public final String keyAlias;
        public final String keyPassword;
        public final String storeType;

        SigningOptions(String storeFile, String storePassword, String keyAlias, String keyPassword, String storeType) {
            this.storeFile = storeFile;
            this.storeType = storeType;
            this.storePassword = storePassword;
            this.keyAlias = keyAlias;
            this.keyPassword = keyPassword;
        }
    }
}

