/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.zip;

import com.android.builder.internal.packaging.zip.ZipField;
import com.android.builder.internal.packaging.zip.ZipFieldInvariantMaxValue;
import com.android.builder.internal.packaging.zip.ZipFieldInvariantNonNegative;
import com.android.builder.internal.packaging.zip.utils.CachedSupplier;
import com.android.builder.internal.utils.IOExceptionWrapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;

class Eocd {
    private static final ZipField.F4 F_SIGNATURE = new ZipField.F4(0, 101010256L, "EOCD signature");
    private static final ZipField.F2 F_NUMBER_OF_DISK = new ZipField.F2(F_SIGNATURE.endOffset(), 0L, "Number of this disk");
    private static final ZipField.F2 F_DISK_CD_START = new ZipField.F2(F_NUMBER_OF_DISK.endOffset(), 0L, "Disk where CD starts");
    private static final ZipField.F2 F_RECORDS_DISK = new ZipField.F2(F_DISK_CD_START.endOffset(), "Record on disk count", new ZipFieldInvariantNonNegative());
    private static final ZipField.F2 F_RECORDS_TOTAL = new ZipField.F2(F_RECORDS_DISK.endOffset(), "Total records", new ZipFieldInvariantNonNegative(), new ZipFieldInvariantMaxValue(Integer.MAX_VALUE));
    @VisibleForTesting
    static final ZipField.F4 F_CD_SIZE = new ZipField.F4(F_RECORDS_TOTAL.endOffset(), "Directory size", new ZipFieldInvariantNonNegative());
    @VisibleForTesting
    static final ZipField.F4 F_CD_OFFSET = new ZipField.F4(F_CD_SIZE.endOffset(), "Directory offset", new ZipFieldInvariantNonNegative());
    private static final ZipField.F2 F_COMMENT_SIZE = new ZipField.F2(F_CD_OFFSET.endOffset(), "File comment size", new ZipFieldInvariantNonNegative());
    private final int mTotalRecords;
    private final long mDirectoryOffset;
    private final long mDirectorySize;
    private final byte[] mComment;
    private final CachedSupplier<byte[]> mByteSupplier;

    Eocd(ByteBuffer bytes) throws IOException {
        F_SIGNATURE.verify(bytes);
        F_NUMBER_OF_DISK.verify(bytes);
        F_DISK_CD_START.verify(bytes);
        long totalRecords1 = F_RECORDS_DISK.read(bytes);
        long totalRecords2 = F_RECORDS_TOTAL.read(bytes);
        long directorySize = F_CD_SIZE.read(bytes);
        long directoryOffset = F_CD_OFFSET.read(bytes);
        int commentSize = Ints.checkedCast((long)F_COMMENT_SIZE.read(bytes));
        if (totalRecords1 != totalRecords2) {
            throw new IOException("Zip states records split in multiple disks, which is not supported.");
        }
        Verify.verify((totalRecords1 <= Integer.MAX_VALUE ? 1 : 0) != 0);
        this.mTotalRecords = Ints.checkedCast((long)totalRecords1);
        this.mDirectorySize = directorySize;
        this.mDirectoryOffset = directoryOffset;
        if (bytes.remaining() < commentSize) {
            throw new IOException("Corrupt EOCD record: not enough data for comment (comment size is " + commentSize + ").");
        }
        this.mComment = new byte[commentSize];
        bytes.get(this.mComment);
        this.mByteSupplier = new CachedSupplier<byte[]>(){

            @Override
            protected byte[] compute() throws IOException {
                return Eocd.this.computeByteRepresentation();
            }
        };
    }

    Eocd(int totalRecords, long directoryOffset, long directorySize) {
        Preconditions.checkArgument((totalRecords >= 0 ? 1 : 0) != 0, (Object)"totalRecords < 0");
        Preconditions.checkArgument((directoryOffset >= 0L ? 1 : 0) != 0, (Object)"directoryOffset < 0");
        Preconditions.checkArgument((directorySize >= 0L ? 1 : 0) != 0, (Object)"directorySize < 0");
        this.mTotalRecords = totalRecords;
        this.mDirectoryOffset = directoryOffset;
        this.mDirectorySize = directorySize;
        this.mComment = new byte[0];
        this.mByteSupplier = new CachedSupplier<byte[]>(){

            @Override
            protected byte[] compute() {
                try {
                    return Eocd.this.computeByteRepresentation();
                }
                catch (IOException e) {
                    throw new IOExceptionWrapper(e);
                }
            }
        };
    }

    int getTotalRecords() {
        return this.mTotalRecords;
    }

    long getDirectoryOffset() {
        return this.mDirectoryOffset;
    }

    long getDirectorySize() {
        return this.mDirectorySize;
    }

    long getEocdSize() {
        return F_COMMENT_SIZE.endOffset() + this.mComment.length;
    }

    byte[] toBytes() throws IOException {
        return this.mByteSupplier.get();
    }

    private byte[] computeByteRepresentation() throws IOException {
        ByteBuffer out = ByteBuffer.allocate(F_COMMENT_SIZE.endOffset() + this.mComment.length);
        F_SIGNATURE.write(out);
        F_NUMBER_OF_DISK.write(out);
        F_DISK_CD_START.write(out);
        F_RECORDS_DISK.write(out, this.mTotalRecords);
        F_RECORDS_TOTAL.write(out, this.mTotalRecords);
        F_CD_SIZE.write(out, this.mDirectorySize);
        F_CD_OFFSET.write(out, this.mDirectoryOffset);
        F_COMMENT_SIZE.write(out, this.mComment.length);
        out.put(this.mComment);
        return out.array();
    }
}

