/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.zip;

import com.android.builder.internal.packaging.zip.CentralDirectoryHeader;
import com.android.builder.internal.packaging.zip.CompressionMethod;

public class CentralDirectoryHeaderCompressInfo {
    public static final long VERSION_WITH_STORE_FILES_ONLY = 10L;
    public static final long VERSION_WITH_DIRECTORIES_AND_DEFLATE = 20L;
    private final CompressionMethod mMethod;
    private final long mCompressedSize;
    private final long mVersionExtract;

    public CentralDirectoryHeaderCompressInfo(CompressionMethod method, long compressedSize, long versionToExtract) {
        this.mMethod = method;
        this.mCompressedSize = compressedSize;
        this.mVersionExtract = versionToExtract;
    }

    public CentralDirectoryHeaderCompressInfo(CentralDirectoryHeader header, CompressionMethod method, long compressedSize) {
        this.mMethod = method;
        this.mCompressedSize = compressedSize;
        this.mVersionExtract = header.getName().endsWith("/") || method == CompressionMethod.DEFLATE ? 20L : 10L;
    }

    public long getCompressedSize() {
        return this.mCompressedSize;
    }

    public CompressionMethod getMethod() {
        return this.mMethod;
    }

    public long getVersionExtract() {
        return this.mVersionExtract;
    }
}

