/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.NodeUtils;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceType;
import com.android.utils.XmlUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class IdGeneratingResourceParser {
    private ResourceItem mFileResourceItem;
    private List<ResourceItem> mIdResourceItems;

    IdGeneratingResourceParser(File file, String sourceName, ResourceType sourceType) throws MergingException {
        Document mDocument = IdGeneratingResourceParser.readDocument(file);
        if (IdGeneratingResourceParser.hasDataBindings(mDocument)) {
            throw MergingException.withMessage("Does not handle data-binding files", new Object[0]).build();
        }
        this.mFileResourceItem = new IdResourceItem(sourceName, sourceType);
        this.mIdResourceItems = Lists.newArrayList();
        HashSet pendingResourceIds = Sets.newHashSet();
        NodeList nodes = mDocument.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            IdGeneratingResourceParser.parseIds(this.mIdResourceItems, child, pendingResourceIds);
        }
        for (String id : pendingResourceIds) {
            IdResourceItem resourceItem = new IdResourceItem(id, ResourceType.ID);
            this.mIdResourceItems.add(resourceItem);
        }
    }

    private static Document readDocument(File file) throws MergingException {
        try {
            return XmlUtils.parseUtfXmlFile((File)file, (boolean)true);
        }
        catch (SAXException e) {
            throw MergingException.wrapException(e).withFile(file).build();
        }
        catch (ParserConfigurationException e) {
            throw MergingException.wrapException(e).withFile(file).build();
        }
        catch (IOException e) {
            throw MergingException.wrapException(e).withFile(file).build();
        }
    }

    private static boolean hasDataBindings(Document document) {
        Element rootNode = document.getDocumentElement();
        return rootNode != null && "layout".equals(rootNode.getNodeName());
    }

    public ResourceItem getFileResourceItem() {
        return this.mFileResourceItem;
    }

    public List<ResourceItem> getIdResourceItems() {
        return this.mIdResourceItems;
    }

    /*
     * WARNING - void declaration
     */
    private static void parseIds(List<ResourceItem> items, Node node, Set<String> pendingResourceIds) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                void var9_11;
                String id;
                Node attribute = attributes.item(i);
                String attrNamespace = attribute.getNamespaceURI();
                if (!"http://schemas.android.com/apk/res/android".equals(attrNamespace)) continue;
                String attrName = attribute.getLocalName();
                String value = attribute.getNodeValue();
                if (value == null) continue;
                if (value.startsWith("@+id/") && !"id".equals(attrName)) {
                    id = value.substring("@+id/".length());
                    if (pendingResourceIds.contains(id)) continue;
                    pendingResourceIds.add(id);
                    continue;
                }
                if (!"id".equals(attrName)) continue;
                if (value.startsWith("@id/")) {
                    id = value.substring("@id/".length());
                    if (!pendingResourceIds.contains(id)) {
                        continue;
                    }
                } else {
                    if (!value.startsWith("@+id/")) continue;
                    id = value.substring("@+id/".length());
                }
                pendingResourceIds.remove(var9_11);
                IdResourceItem item = new IdResourceItem((String)var9_11, ResourceType.ID);
                items.add(item);
            }
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            IdGeneratingResourceParser.parseIds(items, child, pendingResourceIds);
        }
    }

    private static class IdResourceItem
    extends ResourceItem {
        public IdResourceItem(String name, ResourceType type) {
            super(name, type, null, null);
        }

        @Override
        Node getDetailsXml(Document document) {
            Element newNode = document.createElement("item");
            NodeUtils.addAttribute(document, newNode, null, "name", this.getName());
            NodeUtils.addAttribute(document, newNode, null, "type", this.getType().getName());
            if (this.getType() != ResourceType.ID) {
                ResourceFile sourceFile = (ResourceFile)this.getSource();
                assert (sourceFile != null);
                newNode.setTextContent(sourceFile.getFile().getAbsolutePath());
            }
            return newNode;
        }
    }
}

