/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.settings;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ImportSettingsFilenameFilter;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.ServiceBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.Icon;

public class ImportSettings {
    private static final String DIALOG_TITLE = "Setting Synchronization";
    public static final String SETTINGS_JAR_MARKER = "IntelliJ IDEA Global Settings";

    public static void doImport(String path) {
        File saveFile = new File(path);
        try {
            if (!saveFile.exists()) {
                Messages.showErrorDialog((String)IdeBundle.message((String)"error.cannot.find.file", (Object[])new Object[]{ImportSettings.presentableFileName(saveFile)}), (String)DIALOG_TITLE);
                return;
            }
            ZipEntry magicEntry = new ZipFile(saveFile).getEntry(SETTINGS_JAR_MARKER);
            if (magicEntry == null) {
                Messages.showErrorDialog((String)("The file " + ImportSettings.presentableFileName(saveFile) + " contains no settings to import"), (String)DIALOG_TITLE);
                return;
            }
            ArrayList<Object> registeredComponents = new ArrayList<Object>(Arrays.asList(ApplicationManager.getApplication().getComponents(ExportableApplicationComponent.class)));
            registeredComponents.addAll(ServiceBean.loadServicesFromBeans((ExtensionPointName)ExportableComponent.EXTENSION_POINT, ExportableComponent.class));
            List<ExportableComponent> storedComponents = ImportSettings.getComponentsStored(saveFile, registeredComponents);
            HashSet<String> relativeNamesToExtract = new HashSet<String>();
            for (ExportableComponent aComponent : storedComponents) {
                File[] exportFiles;
                for (File exportFile : exportFiles = aComponent.getExportFiles()) {
                    File configPath = new File(PathManager.getConfigPath());
                    String rPath = FileUtil.getRelativePath((File)configPath, (File)exportFile);
                    assert (rPath != null);
                    String relativePath = FileUtil.toSystemIndependentName((String)rPath);
                    relativeNamesToExtract.add(relativePath);
                }
            }
            relativeNamesToExtract.add("installed.txt");
            File tempFile = new File(PathManager.getPluginTempPath() + "/" + saveFile.getName());
            FileUtil.copy((File)saveFile, (File)tempFile);
            File outDir = new File(PathManager.getConfigPath());
            ImportSettingsFilenameFilter filenameFilter = new ImportSettingsFilenameFilter(relativeNamesToExtract);
            StartupActionScriptManager.UnzipCommand unzip = new StartupActionScriptManager.UnzipCommand(tempFile, outDir, (FilenameFilter)filenameFilter);
            StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)unzip);
            StartupActionScriptManager.DeleteCommand deleteTemp = new StartupActionScriptManager.DeleteCommand(tempFile);
            StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)deleteTemp);
            UpdateSettings.getInstance().forceCheckForUpdateAfterRestart();
            String key = ApplicationManager.getApplication().isRestartCapable() ? "message.settings.imported.successfully.restart" : "message.settings.imported.successfully";
            int ret = Messages.showOkCancelDialog((String)IdeBundle.message((String)key, (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName(), ApplicationNamesInfo.getInstance().getFullProductName()}), (String)IdeBundle.message((String)"title.restart.needed", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            if (ret == 0) {
                ((ApplicationEx)ApplicationManager.getApplication()).restart(true);
            }
        }
        catch (ZipException e1) {
            Messages.showErrorDialog((String)("Error reading file " + ImportSettings.presentableFileName(saveFile) + ".\\nThere was " + e1.getMessage()), (String)DIALOG_TITLE);
        }
        catch (IOException e1) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.reading.settings.file.2", (Object[])new Object[]{ImportSettings.presentableFileName(saveFile), e1.getMessage()}), (String)DIALOG_TITLE);
        }
    }

    private static String presentableFileName(File file) {
        return "'" + FileUtil.toSystemDependentName((String)file.getPath()) + "'";
    }

    private static List<ExportableComponent> getComponentsStored(File zipFile, ArrayList<ExportableComponent> registeredComponents) throws IOException {
        File configPath = new File(PathManager.getConfigPath());
        ArrayList<ExportableComponent> components = new ArrayList<ExportableComponent>();
        block0: for (ExportableComponent component : registeredComponents) {
            File[] exportFiles;
            for (File exportFile : exportFiles = component.getExportFiles()) {
                String rPath = FileUtil.getRelativePath((File)configPath, (File)exportFile);
                assert (rPath != null);
                String relativePath = FileUtil.toSystemIndependentName((String)rPath);
                if (exportFile.isDirectory()) {
                    relativePath = relativePath + "/";
                }
                if (!ZipUtil.isZipContainsEntry((File)zipFile, (String)relativePath)) continue;
                components.add(component);
                continue block0;
            }
        }
        return components;
    }
}

