/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.validation;

import com.google.gct.idea.appengine.util.EndpointBundle;
import com.google.gct.idea.appengine.util.EndpointUtilities;
import com.google.gct.idea.appengine.validation.EndpointInspectionBase;
import com.google.gct.idea.appengine.validation.EndpointPsiElementVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InvalidParameterAnnotationsInspection
extends EndpointInspectionBase {
    @Nullable
    public String getStaticDescription() {
        return EndpointBundle.message("invalid.parameter.annotations.description", new Object[0]);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return EndpointBundle.message("invalid.parameter.annotations.name", new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return EndpointBundle.message("invalid.parameter.annotations.short.name", new Object[0]);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new EndpointPsiElementVisitor(){

            public void visitMethod(PsiMethod method) {
                if (!EndpointUtilities.isEndpointClass((PsiElement)method)) {
                    return;
                }
                if (!EndpointUtilities.isApiMethod(method)) {
                    return;
                }
                PsiParameterList parameterList = method.getParameterList();
                if (parameterList.getParametersCount() == 0) {
                    return;
                }
                PsiAnnotation apiMethodAnnotation = method.getModifierList().findAnnotation("com.google.api.server.spi.config.ApiMethod");
                if (apiMethodAnnotation == null) {
                    return;
                }
                PsiAnnotationMemberValue pathMember = apiMethodAnnotation.findAttributeValue("path");
                String path = EndpointUtilities.removeBeginningAndEndingQuotes(pathMember.getText());
                Collection<String> pathParameters = this.getPathParameters(path);
                if (pathParameters.size() == 0) {
                    return;
                }
                for (PsiParameter aParameter : parameterList.getParameters()) {
                    String nameValue;
                    PsiAnnotationMemberValue namedAnnotation = this.getNamedAnnotationValue(aParameter);
                    if (namedAnnotation == null || !pathParameters.contains(nameValue = EndpointUtilities.removeBeginningAndEndingQuotes(namedAnnotation.getText())) || aParameter.getModifierList().findAnnotation("com.google.api.server.spi.config.Nullable") == null && aParameter.getModifierList().findAnnotation("javax.annotation.Nullable") == null && aParameter.getModifierList().findAnnotation("com.google.api.server.spi.config.DefaultValue") == null) continue;
                    holder.registerProblem((PsiElement)aParameter, "Invalid parameter configuration. A parameter in the method path should not be marked @Nullable or @DefaultValue.", new LocalQuickFix[]{new MyQuickFix()});
                }
            }

            private Collection<String> getPathParameters(String path) {
                Pattern pathPattern = Pattern.compile("\\{([^\\}]*)\\}");
                Matcher pathMatcher = pathPattern.matcher(path);
                HashSet<String> pathParameters = new HashSet<String>();
                while (pathMatcher.find()) {
                    pathParameters.add(pathMatcher.group(1));
                }
                return pathParameters;
            }
        };
    }

    public class MyQuickFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return this.getFamilyName() + ": Remove @Nullable and/or @DefaultValue";
        }

        @NotNull
        public String getFamilyName() {
            return EndpointBundle.message("api.name.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiAnnotation defaultValueAnnotation;
            PsiAnnotation javaxNullableAnnotation;
            PsiElement element = descriptor.getPsiElement();
            if (element == null) {
                return;
            }
            if (!(element instanceof PsiParameter)) {
                return;
            }
            PsiModifierList modifierList = ((PsiParameter)element).getModifierList();
            PsiAnnotation gaeNullableAnnotation = modifierList.findAnnotation("com.google.api.server.spi.config.Nullable");
            if (gaeNullableAnnotation != null) {
                gaeNullableAnnotation.delete();
            }
            if ((javaxNullableAnnotation = modifierList.findAnnotation("javax.annotation.Nullable")) != null) {
                javaxNullableAnnotation.delete();
            }
            if ((defaultValueAnnotation = modifierList.findAnnotation("com.google.api.server.spi.config.DefaultValue")) != null) {
                defaultValueAnnotation.delete();
            }
        }
    }
}

