/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.validation;

import com.google.common.collect.Maps;
import com.google.gct.idea.appengine.util.EndpointBundle;
import com.google.gct.idea.appengine.util.EndpointUtilities;
import com.google.gct.idea.appengine.validation.EndpointInspectionBase;
import com.google.gct.idea.appengine.validation.EndpointPsiElementVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FullJavaNameInspection
extends EndpointInspectionBase {
    @Nullable
    public String getStaticDescription() {
        return EndpointBundle.message("backend.name.description", new Object[0]);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return EndpointBundle.message("backend.name.name", new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return EndpointBundle.message("backend.name.short.name", new Object[0]);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new EndpointPsiElementVisitor(){

            public void visitClass(PsiClass aClass) {
                if (!EndpointUtilities.isEndpointClass((PsiElement)aClass)) {
                    return;
                }
                PsiMethod[] allMethods = aClass.getMethods();
                HashMap javaMethodNames = Maps.newHashMap();
                for (PsiMethod aMethod : allMethods) {
                    this.validateBackendMethodNameUnique(aMethod, javaMethodNames);
                }
            }

            private void validateBackendMethodNameUnique(PsiMethod psiMethod, Map<String, PsiMethod> javaMethodNames) {
                if (!EndpointUtilities.isApiMethod(psiMethod)) {
                    return;
                }
                if (psiMethod.isConstructor()) {
                    return;
                }
                String javaName = psiMethod.getContainingClass().getQualifiedName() + "." + psiMethod.getName();
                PsiMethod seenMethod = javaMethodNames.get(javaName);
                if (seenMethod == null) {
                    javaMethodNames.put(javaName, psiMethod);
                } else {
                    String psiMethodName = psiMethod.getContainingClass().getName() + "." + psiMethod.getName() + psiMethod.getParameterList().getText();
                    String seenMethodName = seenMethod.getContainingClass().getName() + "." + seenMethod.getName() + seenMethod.getParameterList().getText();
                    holder.registerProblem((PsiElement)psiMethod, "Overloaded methods are not supported. " + javaName + " has at least one overload: " + psiMethodName + " and " + seenMethodName, new LocalQuickFix[]{new MyQuickFix()});
                }
            }
        };
    }

    public class MyQuickFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return this.getFamilyName() + ": Rename method";
        }

        @NotNull
        public String getFamilyName() {
            return FullJavaNameInspection.this.getDisplayName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)element;
            method.setName(method.getName() + "_1");
        }
    }
}

