/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.properties;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.tmatesoft.svn.core.wc.SVNPropertyData;

public class PropertyData {
    @Nullable
    private final PropertyValue myValue;
    @NotNull
    private final String myName;

    public PropertyData(@NotNull String name, @Nullable PropertyValue value) {
        this.myName = name;
        this.myValue = value;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @Nullable
    public PropertyValue getValue() {
        return this.myValue;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static PropertyData create(@Nullable SVNPropertyData data) {
        PropertyData result = null;
        if (data != null) {
            result = new PropertyData(data.getName(), PropertyValue.create(data.getValue()));
        }
        return result;
    }
}

