/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AreaMap;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.mergeinfo.BranchInfo;
import org.jetbrains.idea.svn.mergeinfo.MergeChecker;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;
import org.jetbrains.idea.svn.properties.PropertyConsumer;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class OneShotMergeInfoHelper
implements MergeChecker {
    @NotNull
    private final MergeContext myMergeContext;
    @NotNull
    private final Map<Long, Collection<String>> myPartiallyMerged;
    @NotNull
    private final AreaMap<String, Map<String, SVNMergeRangeList>> myMergeInfoMap;
    @NotNull
    private final Object myMergeInfoLock;

    public OneShotMergeInfoHelper(@NotNull MergeContext mergeContext) {
        this.myMergeContext = mergeContext;
        this.myPartiallyMerged = ContainerUtil.newHashMap();
        this.myMergeInfoLock = new Object();
        this.myMergeInfoMap = AreaMap.create((PairProcessor)new PairProcessor<String, String>(){

            public boolean process(String parentUrl, String childUrl) {
                if (".".equals(parentUrl)) {
                    return true;
                }
                return SVNPathUtil.isAncestor((String)SvnUtil.ensureStartSlash(parentUrl), (String)SvnUtil.ensureStartSlash(childUrl));
            }
        });
    }

    @Override
    public void prepare() throws VcsException {
        Depth depth = Depth.allOrEmpty(this.myMergeContext.getVcs().getSvnConfiguration().isCheckNestedForQuickMerge());
        File file = this.myMergeContext.getWcInfo().getRootInfo().getIoFile();
        this.myMergeContext.getVcs().getFactory(file).createPropertyClient().getProperty(SvnTarget.fromFile((File)file), "svn:mergeinfo", SVNRevision.WORKING, depth, this.createPropertyHandler());
    }

    @Override
    @Nullable
    public Collection<String> getNotMergedPaths(@NotNull SvnChangeList changeList) {
        return this.myPartiallyMerged.get(changeList.getNumber());
    }

    @Override
    @NotNull
    public SvnMergeInfoCache.MergeCheckResult checkList(@NotNull SvnChangeList changeList) {
        HashSet notMergedPaths = ContainerUtil.newHashSet();
        boolean hasMergedPaths = false;
        for (String path : changeList.getAffectedPaths()) {
            switch (this.checkPath(path, changeList.getNumber())) {
                case MERGED: {
                    hasMergedPaths = true;
                    break;
                }
                case NOT_MERGED: {
                    notMergedPaths.add(path);
                }
            }
        }
        if (hasMergedPaths && !notMergedPaths.isEmpty()) {
            this.myPartiallyMerged.put(changeList.getNumber(), notMergedPaths);
        }
        return notMergedPaths.isEmpty() ? (hasMergedPaths ? SvnMergeInfoCache.MergeCheckResult.MERGED : SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS) : SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SvnMergeInfoCache.MergeCheckResult checkPath(@NotNull String repositoryRelativePath, long revisionNumber) {
        SvnMergeInfoCache.MergeCheckResult result;
        String sourceRelativePath = SVNPathUtil.getRelativePath((String)this.myMergeContext.getRepositoryRelativeSourcePath(), (String)SvnUtil.ensureStartSlash(repositoryRelativePath));
        if (sourceRelativePath == null) {
            result = SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS;
        } else {
            InfoProcessor processor = new InfoProcessor(sourceRelativePath, this.myMergeContext.getRepositoryRelativeSourcePath(), revisionNumber);
            Object object = this.myMergeInfoLock;
            synchronized (object) {
                this.myMergeInfoMap.getSimiliar((Object)OneShotMergeInfoHelper.toKey(sourceRelativePath), (PairProcessor)processor);
            }
            result = SvnMergeInfoCache.MergeCheckResult.getInstance(processor.isMerged());
        }
        return result;
    }

    @NotNull
    private PropertyConsumer createPropertyHandler() {
        return new PropertyConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleProperty(@NotNull File path, @NotNull PropertyData property) throws SVNException {
                Map<String, SVNMergeRangeList> mergeInfo;
                String workingCopyRelativePath = OneShotMergeInfoHelper.this.getWorkingCopyRelativePath(path);
                try {
                    mergeInfo = BranchInfo.parseMergeInfo((PropertyValue)ObjectUtils.assertNotNull((Object)property.getValue()));
                }
                catch (SvnBindException e) {
                    throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.MERGE_INFO_PARSE_ERROR, (Throwable)((Object)e)), (Throwable)((Object)e));
                }
                Object object = OneShotMergeInfoHelper.this.myMergeInfoLock;
                synchronized (object) {
                    OneShotMergeInfoHelper.this.myMergeInfoMap.put((Object)OneShotMergeInfoHelper.toKey(workingCopyRelativePath), mergeInfo);
                }
            }

            @Override
            public void handleProperty(SVNURL url, PropertyData property) throws SVNException {
            }

            @Override
            public void handleProperty(long revision, PropertyData property) throws SVNException {
            }
        };
    }

    @NotNull
    private String getWorkingCopyRelativePath(@NotNull File file) {
        return FileUtil.toSystemIndependentName((String)((String)ObjectUtils.assertNotNull((Object)FileUtil.getRelativePath((File)this.myMergeContext.getWcInfo().getRootInfo().getIoFile(), (File)file))));
    }

    @NotNull
    private static String toKey(@NotNull String path) {
        return SystemInfo.isFileSystemCaseSensitive ? path : path.toUpperCase();
    }

    private static class InfoProcessor
    implements PairProcessor<String, Map<String, SVNMergeRangeList>> {
        @NotNull
        private final String myRepositoryRelativeSourcePath;
        private boolean myIsMerged;
        @NotNull
        private final String mySourceRelativePath;
        private final long myRevisionNumber;

        public InfoProcessor(@NotNull String sourceRelativePath, @NotNull String repositoryRelativeSourcePath, long revisionNumber) {
            this.mySourceRelativePath = sourceRelativePath;
            this.myRevisionNumber = revisionNumber;
            this.myRepositoryRelativeSourcePath = SvnUtil.ensureStartSlash(repositoryRelativeSourcePath);
        }

        public boolean isMerged() {
            return this.myIsMerged;
        }

        public boolean process(@NotNull String workingCopyRelativePath, @NotNull Map<String, SVNMergeRangeList> mergedPathsMap) {
            boolean processed = false;
            final boolean isCurrentPath = workingCopyRelativePath.equals(this.mySourceRelativePath);
            if (mergedPathsMap.isEmpty()) {
                this.myIsMerged = false;
                processed = true;
            } else {
                String mergedPathAffectingSourcePath = (String)ContainerUtil.find(mergedPathsMap.keySet(), (Condition)new Condition<String>(){

                    public boolean value(String path) {
                        return SVNPathUtil.isAncestor((String)myRepositoryRelativeSourcePath, (String)SvnUtil.ensureStartSlash(path));
                    }
                });
                if (mergedPathAffectingSourcePath != null) {
                    SVNMergeRangeList mergeRangeList = mergedPathsMap.get(mergedPathAffectingSourcePath);
                    processed = true;
                    this.myIsMerged = ContainerUtil.or((Object[])mergeRangeList.getRanges(), (Condition)new Condition<SVNMergeRange>(){

                        public boolean value(@NotNull SVNMergeRange range) {
                            return BranchInfo.isInRange(range, myRevisionNumber) && (range.isInheritable() || isCurrentPath);
                        }
                    });
                }
            }
            return processed;
        }
    }
}

