/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;

public class MergeInfoCached {
    @NotNull
    private final Map<Long, SvnMergeInfoCache.MergeCheckResult> myMap;
    private final long myCopyRevision;

    public MergeInfoCached() {
        this.myMap = ContainerUtil.newHashMap();
        this.myCopyRevision = -1L;
    }

    public MergeInfoCached(@NotNull Map<Long, SvnMergeInfoCache.MergeCheckResult> map, long copyRevision) {
        this.myMap = ContainerUtil.newHashMap(map);
        this.myCopyRevision = copyRevision;
    }

    @NotNull
    public Map<Long, SvnMergeInfoCache.MergeCheckResult> getMap() {
        return this.myMap;
    }

    @NotNull
    public MergeInfoCached copy() {
        return new MergeInfoCached(this.myMap, this.myCopyRevision);
    }

    public boolean copiedAfter(@NotNull CommittedChangeList list) {
        return this.myCopyRevision != -1L && this.myCopyRevision >= list.getNumber();
    }
}

