/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.PairConsumer;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.dialogs.IntersectingLocalChangesPanel;
import org.jetbrains.idea.svn.dialogs.MergeDialogI;
import org.jetbrains.idea.svn.integrate.LocalChangesAction;
import org.jetbrains.idea.svn.integrate.QuickMergeContentsVariants;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;
import org.jetbrains.idea.svn.integrate.QuickMergeWayOptionsPanel;
import org.jetbrains.idea.svn.integrate.ToBeMergedDialog;
import org.jetbrains.idea.svn.mergeinfo.MergeChecker;

public class QuickMergeInteractionImpl
implements QuickMergeInteraction {
    private final Project myProject;
    private String myTitle;

    public QuickMergeInteractionImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public void setTitle(@NotNull String title) {
        this.myTitle = title;
    }

    @Override
    public QuickMergeContentsVariants selectMergeVariant() {
        QuickMergeWayOptionsPanel panel = new QuickMergeWayOptionsPanel();
        DialogBuilder builder = new DialogBuilder(this.myProject);
        builder.removeAllActions();
        builder.setTitle("Select Merge Variant");
        builder.setCenterPanel((JComponent)panel.getMainPanel());
        panel.setWrapper(builder.getDialogWrapper());
        builder.show();
        return panel.getVariant();
    }

    @Override
    public boolean shouldContinueSwitchedRootFound() {
        return this.prompt("There are some switched paths in the working copy. Do you want to continue?");
    }

    @Override
    public boolean shouldReintegrate(@NotNull String sourceUrl, @NotNull String targetUrl) {
        return this.prompt("<html><body>You are going to reintegrate changes.<br><br>This will make branch '" + sourceUrl + "' <b>no longer usable for further work</b>." + "<br>It will not be able to correctly absorb new trunk (" + targetUrl + ") changes,<br>nor can this branch be properly reintegrated to trunk again.<br><br>Are you sure?</body></html>");
    }

    @Override
    @NotNull
    public QuickMergeInteraction.SelectMergeItemsResult selectMergeItems(List<CommittedChangeList> lists, String mergeTitle, MergeChecker mergeChecker) {
        final ToBeMergedDialog dialog = new ToBeMergedDialog(this.myProject, lists, mergeTitle, mergeChecker, null);
        dialog.show();
        return new QuickMergeInteraction.SelectMergeItemsResult(){

            @Override
            public QuickMergeContentsVariants getResultCode() {
                int code = dialog.getExitCode();
                if (222 == code) {
                    return QuickMergeContentsVariants.all;
                }
                return 0 == code ? QuickMergeContentsVariants.select : QuickMergeContentsVariants.cancel;
            }

            @Override
            public List<CommittedChangeList> getSelectedLists() {
                return dialog.getSelected();
            }
        };
    }

    @Override
    @NotNull
    public LocalChangesAction selectLocalChangesAction(boolean mergeAll) {
        if (!mergeAll) {
            LocalChangesAction[] possibleResults = new LocalChangesAction[]{LocalChangesAction.shelve, LocalChangesAction.inspect, LocalChangesAction.continueMerge, LocalChangesAction.cancel};
            int result = Messages.showDialog((String)"There are local changes that will intersect with merge changes.\nDo you want to continue?", (String)this.myTitle, (String[])new String[]{"Shelve local changes", "Inspect changes", "Continue merge", "Cancel"}, (int)0, (Icon)Messages.getQuestionIcon());
            return possibleResults[result];
        }
        LocalChangesAction[] possibleResults = new LocalChangesAction[]{LocalChangesAction.shelve, LocalChangesAction.continueMerge, LocalChangesAction.cancel};
        int result = Messages.showDialog((String)"There are local changes that can potentially intersect with merge changes.\nDo you want to continue?", (String)this.myTitle, (String[])new String[]{"Shelve local changes", "Continue merge", "Cancel"}, (int)0, (Icon)Messages.getQuestionIcon());
        return possibleResults[result];
    }

    @Override
    public void showIntersectedLocalPaths(List<FilePath> paths) {
        IntersectingLocalChangesPanel.showInVersionControlToolWindow(this.myProject, this.myTitle + ", local changes intersection", paths, "The following file(s) have local changes that will intersect with merge changes:");
    }

    @Override
    public void showError(@NotNull Exception exception) {
        AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(Collections.singletonList(new VcsException((Throwable)exception)), exception.getMessage() == null ? exception.getClass().getName() : exception.getMessage());
    }

    @Override
    public void showErrors(String message, List<VcsException> exceptions) {
        AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(exceptions, message);
    }

    @Override
    public void showErrors(String message, boolean isError) {
        VcsBalloonProblemNotifier.showOverChangesView((Project)this.myProject, (String)message, (MessageType)(isError ? MessageType.ERROR : MessageType.WARNING), (NamedRunnable[])new NamedRunnable[0]);
    }

    @Override
    public List<CommittedChangeList> showRecentListsForSelection(@NotNull List<CommittedChangeList> list, @NotNull String mergeTitle, @NotNull MergeChecker mergeChecker, @NotNull PairConsumer<Long, MergeDialogI> loader, boolean everyThingLoaded) {
        ToBeMergedDialog dialog = new ToBeMergedDialog(this.myProject, list, mergeTitle, mergeChecker, loader);
        if (everyThingLoaded) {
            dialog.setEverythingLoaded(true);
        }
        dialog.show();
        if (0 == dialog.getExitCode()) {
            return dialog.getSelected();
        }
        return null;
    }

    private boolean prompt(String question) {
        return Messages.showOkCancelDialog((Project)this.myProject, (String)question, (String)this.myTitle, (Icon)Messages.getQuestionIcon()) == 0;
    }
}

