/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.TransparentlyFailedValueI;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryPath;
import org.jetbrains.idea.svn.history.LogHierarchyNode;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnCommittedChangesProvider;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;
import org.jetbrains.idea.svn.integrate.SvnBranchPointsCalculator;
import org.jetbrains.idea.svn.mergeinfo.MergeChecker;
import org.jetbrains.idea.svn.mergeinfo.OneShotMergeInfoHelper;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class MergeCalculatorTask
extends BaseMergeTask
implements Consumer<TransparentlyFailedValueI<SvnBranchPointsCalculator.WrapperInvertor, VcsException>> {
    @NotNull
    private final AtomicReference<TransparentlyFailedValueI<SvnBranchPointsCalculator.WrapperInvertor, VcsException>> myCopyData;
    @NotNull
    private final String myMergeTitle;
    @NotNull
    private final MergeChecker myMergeChecker;

    public void consume(TransparentlyFailedValueI<SvnBranchPointsCalculator.WrapperInvertor, VcsException> value) {
        this.myCopyData.set(value);
    }

    public MergeCalculatorTask(@NotNull MergeContext mergeContext, @NotNull QuickMergeInteraction interaction) throws VcsException {
        super(mergeContext, interaction, "Calculating not merged revisions", Where.POOLED);
        this.myMergeTitle = "Merge from " + this.myMergeContext.getBranchName();
        this.myMergeChecker = new OneShotMergeInfoHelper(this.myMergeContext);
        ((OneShotMergeInfoHelper)this.myMergeChecker).prepare();
        this.myCopyData = new AtomicReference();
    }

    public void run(ContinuationContext context) {
        SvnBranchPointsCalculator.WrapperInvertor copyPoint = this.getCopyPoint(context);
        if (copyPoint != null && this.myMergeContext.getWcInfo().getFormat().supportsMergeInfo()) {
            LinkedList<Pair<SvnChangeList, LogHierarchyNode>> afterCopyPointChangeLists = this.getChangeListsAfter(context, copyPoint.getTrue().getTargetRevision());
            List<CommittedChangeList> notMergedChangeLists = this.getNotMergedChangeLists(afterCopyPointChangeLists);
            if (!notMergedChangeLists.isEmpty()) {
                context.next(new TaskDescriptor[]{new ShowRevisionSelector(copyPoint, notMergedChangeLists)});
            } else {
                this.finishWithError(context, "Everything is up-to-date", false);
            }
        }
    }

    @Nullable
    private SvnBranchPointsCalculator.WrapperInvertor getCopyPoint(@NotNull ContinuationContext context) {
        SvnBranchPointsCalculator.WrapperInvertor result = null;
        try {
            result = (SvnBranchPointsCalculator.WrapperInvertor)this.myCopyData.get().get();
            if (result == null) {
                this.finishWithError(context, "Merge start wasn't found", true);
            }
        }
        catch (VcsException e) {
            this.finishWithError(context, "Merge start wasn't found", Collections.singletonList(e));
        }
        return result;
    }

    @NotNull
    private LinkedList<Pair<SvnChangeList, LogHierarchyNode>> getChangeListsAfter(@NotNull ContinuationContext context, final long revision) {
        ChangeBrowserSettings settings = new ChangeBrowserSettings();
        settings.CHANGE_AFTER = Long.toString(revision);
        settings.USE_CHANGE_AFTER_FILTER = true;
        final LinkedList result = ContainerUtil.newLinkedList();
        final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        try {
            ((SvnCommittedChangesProvider)this.myMergeContext.getVcs().getCommittedChangesProvider()).getCommittedChangesWithMergedRevisons(settings, new SvnRepositoryLocation(this.myMergeContext.getSourceUrl()), 0, new PairConsumer<SvnChangeList, LogHierarchyNode>(){

                public void consume(@NotNull SvnChangeList changeList, LogHierarchyNode tree) {
                    indicator.checkCanceled();
                    if (revision < changeList.getNumber()) {
                        result.add(Pair.create((Object)changeList, (Object)tree));
                    }
                }
            });
        }
        catch (VcsException e) {
            this.finishWithError(context, "Checking revisions for merge fault", Collections.singletonList(e));
        }
        return result;
    }

    @NotNull
    private List<CommittedChangeList> getNotMergedChangeLists(@NotNull List<Pair<SvnChangeList, LogHierarchyNode>> changeLists) {
        ProgressManager.getInstance().getProgressIndicator().setText("Checking merge information...");
        String repositoryRelativeWorkingCopyRoot = SvnUtil.ensureStartSlash(SVNPathUtil.getRelativePath((String)this.myMergeContext.getWcInfo().getRepositoryRoot(), (String)this.myMergeContext.getWcInfo().getRootUrl()));
        String repositoryRelativeSourceBranch = SvnUtil.ensureStartSlash(SVNPathUtil.getRelativePath((String)this.myMergeContext.getWcInfo().getRepositoryRoot(), (String)this.myMergeContext.getSourceUrl()));
        return this.getNotMergedChangeLists(changeLists, repositoryRelativeWorkingCopyRoot, repositoryRelativeSourceBranch);
    }

    @NotNull
    private List<CommittedChangeList> getNotMergedChangeLists(@NotNull List<Pair<SvnChangeList, LogHierarchyNode>> changeLists, @NotNull String workingCopyRoot, @NotNull String sourceBranch) {
        ArrayList result = ContainerUtil.newArrayList();
        for (Pair<SvnChangeList, LogHierarchyNode> pair : changeLists) {
            SvnChangeList changeList = (SvnChangeList)pair.getFirst();
            ProgressManager.getInstance().getProgressIndicator().setText2("Processing revision " + changeList.getNumber());
            if (!SvnMergeInfoCache.MergeCheckResult.NOT_MERGED.equals((Object)this.myMergeChecker.checkList(changeList)) || MergeCalculatorTask.checkListForPaths(workingCopyRoot, sourceBranch, (LogHierarchyNode)pair.getSecond())) continue;
            result.add(changeList);
        }
        return result;
    }

    static boolean checkListForPaths(final @NotNull String workingCopyRoot, final @NotNull String sourceBranch, @NotNull LogHierarchyNode node) {
        boolean isLocalChange = ContainerUtil.or(node.getChildren(), (Condition)new Condition<LogHierarchyNode>(){

            public boolean value(@NotNull LogHierarchyNode child) {
                return MergeCalculatorTask.checkForSubtree(child, workingCopyRoot, sourceBranch);
            }
        });
        return isLocalChange || MergeCalculatorTask.checkForEntry(node.getMe(), workingCopyRoot, sourceBranch);
    }

    private static boolean checkForSubtree(@NotNull LogHierarchyNode tree, @NotNull String relativeBranch, @NotNull String localURL) {
        LinkedList<LogHierarchyNode> queue = new LinkedList<LogHierarchyNode>();
        queue.addLast(tree);
        while (!queue.isEmpty()) {
            LogHierarchyNode element = (LogHierarchyNode)queue.removeFirst();
            ProgressManager.checkCanceled();
            if (MergeCalculatorTask.checkForEntry(element.getMe(), localURL, relativeBranch)) {
                return true;
            }
            queue.addAll(element.getChildren());
        }
        return false;
    }

    private static boolean checkForEntry(@NotNull LogEntry entry, @NotNull String localURL, @NotNull String relativeBranch) {
        boolean atLeastOneUnderBranch = false;
        for (LogEntryPath path : entry.getChangedPaths().values()) {
            if (SVNPathUtil.isAncestor((String)localURL, (String)path.getPath())) {
                return true;
            }
            if (atLeastOneUnderBranch || !SVNPathUtil.isAncestor((String)relativeBranch, (String)path.getPath())) continue;
            atLeastOneUnderBranch = true;
        }
        return !atLeastOneUnderBranch;
    }

    private class ShowRevisionSelector
    extends TaskDescriptor {
        @NotNull
        private final List<CommittedChangeList> myChangeLists;
        @NotNull
        private final SvnBranchPointsCalculator.WrapperInvertor myCopyPoint;

        private ShowRevisionSelector(@NotNull SvnBranchPointsCalculator.WrapperInvertor copyPoint, List<CommittedChangeList> changeLists) {
            super("show revisions to merge", Where.AWT);
            this.myCopyPoint = copyPoint;
            this.myChangeLists = changeLists;
        }

        public void run(ContinuationContext context) {
            QuickMergeInteraction.SelectMergeItemsResult result = MergeCalculatorTask.this.myInteraction.selectMergeItems(this.myChangeLists, MergeCalculatorTask.this.myMergeTitle, MergeCalculatorTask.this.myMergeChecker);
            switch (result.getResultCode()) {
                case cancel: {
                    context.cancelEverything();
                    break;
                }
                case all: {
                    context.next(MergeCalculatorTask.this.getMergeAllTasks());
                    break;
                }
                default: {
                    List<CommittedChangeList> lists = result.getSelectedLists();
                    if (lists.isEmpty()) break;
                    MergeCalculatorTask.this.runChangeListsMerge(context, lists, this.myCopyPoint, MergeCalculatorTask.this.myMergeTitle);
                }
            }
        }
    }
}

