/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.diff.DiffOptions;
import org.jetbrains.idea.svn.integrate.IMerger;
import org.jetbrains.idea.svn.integrate.MergeClient;
import org.jetbrains.idea.svn.update.UpdateEventHandler;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class BranchMerger
implements IMerger {
    private static final Logger LOG = Logger.getInstance(BranchMerger.class);
    private final SvnVcs myVcs;
    private final String myTargetPath;
    private final SVNURL mySourceUrl;
    private final UpdateEventHandler myHandler;
    private final boolean myReintegrate;
    private final String myBranchName;
    private final long mySourceCopyRevision;
    private boolean myAtStart;
    private SVNRevision mySourceLatestRevision;

    public BranchMerger(SvnVcs vcs, SVNURL sourceUrl, String targetPath, UpdateEventHandler handler, boolean isReintegrate, String branchName, long sourceCopyRevision) {
        this.myVcs = vcs;
        this.myTargetPath = targetPath;
        this.mySourceUrl = sourceUrl;
        this.myHandler = handler;
        this.myReintegrate = isReintegrate;
        this.myBranchName = branchName;
        this.mySourceCopyRevision = sourceCopyRevision;
        this.myAtStart = true;
        this.mySourceLatestRevision = this.resolveSourceLatestRevision();
    }

    @Override
    public String getComment() {
        return "Merge all from " + this.myBranchName + " at " + this.mySourceLatestRevision + (this.myReintegrate ? " (reintegration)" : "");
    }

    @Override
    public boolean hasNext() {
        return this.myAtStart;
    }

    @Override
    public void mergeNext() throws VcsException {
        this.myAtStart = false;
        File destination = new File(this.myTargetPath);
        MergeClient client = this.myVcs.getFactory(destination).createMergeClient();
        if (this.myReintegrate) {
            client.merge(SvnTarget.fromURL((SVNURL)this.mySourceUrl), destination, false, this.createDiffOptions(), this.myHandler);
        } else {
            client.merge(SvnTarget.fromURL((SVNURL)this.mySourceUrl, (SVNRevision)SVNRevision.create((long)this.mySourceCopyRevision)), SvnTarget.fromURL((SVNURL)this.mySourceUrl, (SVNRevision)this.mySourceLatestRevision), destination, Depth.INFINITY, true, false, false, true, this.createDiffOptions(), this.myHandler);
        }
    }

    @NotNull
    private DiffOptions createDiffOptions() {
        return this.myVcs.getSvnConfiguration().getMergeOptions();
    }

    @Override
    @Nullable
    public String getInfo() {
        return null;
    }

    @Override
    public File getMergeInfoHolder() {
        return new File(this.myTargetPath);
    }

    @Override
    public void afterProcessing() {
    }

    @Override
    @Nullable
    public String getSkipped() {
        return null;
    }

    @NotNull
    public SVNRevision resolveSourceLatestRevision() {
        SVNRevision result = SVNRevision.HEAD;
        try {
            result = SvnUtil.getHeadRevision(this.myVcs, this.mySourceUrl);
        }
        catch (SvnBindException e) {
            LOG.info((Throwable)((Object)e));
        }
        return result;
    }
}

