/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.difftool.properties;

import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DiffContentBase;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.properties.PropertyData;

public class SvnPropertiesDiffRequest
extends ContentDiffRequest {
    @NotNull
    private final List<DiffContent> myContents;
    @NotNull
    private final List<String> myContentTitles;
    @NotNull
    private final String myWindowTitle;

    public SvnPropertiesDiffRequest(@NotNull String windowTitle, @NotNull DiffContent content1, @NotNull DiffContent content2, @NotNull String title1, @NotNull String title2) {
        this.myWindowTitle = windowTitle;
        this.myContents = ContainerUtil.list((Object[])new DiffContent[]{content1, content2});
        this.myContentTitles = ContainerUtil.list((Object[])new String[]{title1, title2});
        assert (content1 instanceof PropertyContent || content1 instanceof EmptyContent);
        assert (content2 instanceof PropertyContent || content2 instanceof EmptyContent);
        assert (content1 instanceof PropertyContent || content2 instanceof PropertyContent);
    }

    public SvnPropertiesDiffRequest(@Nullable List<PropertyData> before, @Nullable List<PropertyData> after, @Nullable String title1, @Nullable String title2) {
        assert (before != null || after != null);
        this.myContents = ContainerUtil.list((Object[])new DiffContent[]{this.createContent(before), this.createContent(after)});
        this.myWindowTitle = "Svn Properties Diff";
        this.myContentTitles = ContainerUtil.list((Object[])new String[]{title1, title2});
    }

    @NotNull
    public DiffContent createContent(@Nullable List<PropertyData> content) {
        if (content == null) {
            return new EmptyContent();
        }
        return new PropertyContent(content);
    }

    @NotNull
    public String getTitle() {
        return this.myWindowTitle;
    }

    @NotNull
    public List<String> getContentTitles() {
        return this.myContentTitles;
    }

    @NotNull
    public List<DiffContent> getContents() {
        return this.myContents;
    }

    public static class PropertyContent
    extends DiffContentBase {
        @NotNull
        private final List<PropertyData> myProperties;

        public PropertyContent(@NotNull List<PropertyData> properties) {
            this.myProperties = properties;
        }

        @NotNull
        public List<PropertyData> getProperties() {
            return this.myProperties;
        }

        @Nullable
        public FileType getContentType() {
            return null;
        }
    }
}

