/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.diff;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.diff.DiffClient;
import org.jetbrains.idea.svn.diff.SvnDiffEditor;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.svnkit.SvnKitProgressCanceller;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNReporter;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc17.SVNReporter17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnKitDiffClient
extends BaseSvnClient
implements DiffClient {
    @Override
    @NotNull
    public List<Change> compare(@NotNull SvnTarget target1, @NotNull SvnTarget target2) throws VcsException {
        DiffExecutor executor = new DiffExecutor(target1, target2);
        try {
            executor.run();
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
        return executor.getChanges();
    }

    @Override
    public void unifiedDiff(@NotNull SvnTarget target1, @NotNull SvnTarget target2, @NotNull OutputStream output) throws VcsException {
        this.assertUrl(target1);
        this.assertUrl(target2);
        try {
            this.myVcs.getSvnKitManager().createDiffClient().doDiff(target1.getURL(), target1.getPegRevision(), target2.getURL(), target2.getPegRevision(), true, false, output);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    private class DiffExecutor {
        @NotNull
        private final SvnTarget myTarget1;
        @NotNull
        private final SvnTarget myTarget2;
        @NotNull
        private final List<Change> myChanges;

        private DiffExecutor(@NotNull SvnTarget target1, SvnTarget target2) {
            this.myTarget1 = target1;
            this.myTarget2 = target2;
            this.myChanges = ContainerUtil.newArrayList();
        }

        @NotNull
        public List<Change> getChanges() {
            return this.myChanges;
        }

        public void run() throws SVNException {
            SvnKitDiffClient.this.assertUrl(this.myTarget1);
            if (this.myTarget2.isFile()) {
                SvnKitDiffClient.this.assertDirectory(this.myTarget2);
                WorkingCopyFormat format = SvnKitDiffClient.this.myVcs.getWorkingCopyFormat(this.myTarget2.getFile());
                this.myChanges.addAll(WorkingCopyFormat.ONE_DOT_SIX.equals((Object)format) ? this.run16Diff() : this.run17Diff());
            } else {
                this.myChanges.addAll(this.runUrlDiff());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection<Change> runUrlDiff() throws SVNException {
            SVNRepository sourceRepository = SvnKitDiffClient.this.myVcs.getSvnKitManager().createRepository(this.myTarget1.getURL());
            sourceRepository.setCanceller((ISVNCanceller)new SvnKitProgressCanceller());
            SVNRepository targetRepository = null;
            try {
                final long rev = sourceRepository.getLatestRevision();
                targetRepository = SvnKitDiffClient.this.myVcs.getSvnKitManager().createRepository(this.myTarget2.getURL());
                SvnDiffEditor diffEditor = new SvnDiffEditor(sourceRepository, targetRepository, -1L, false);
                ISVNEditor cancellableEditor = SVNCancellableEditor.newInstance((ISVNEditor)diffEditor, (ISVNCanceller)new SvnKitProgressCanceller(), null);
                sourceRepository.diff(this.myTarget2.getURL(), rev, rev, null, true, true, false, new ISVNReporterBaton(){

                    public void report(ISVNReporter reporter) throws SVNException {
                        reporter.setPath("", null, rev, false);
                        reporter.finishReport();
                    }
                }, cancellableEditor);
                Collection<Change> collection = diffEditor.getChangesMap().values();
                return collection;
            }
            finally {
                sourceRepository.closeSession();
                if (targetRepository != null) {
                    targetRepository.closeSession();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection<Change> run17Diff() throws SVNException {
            SVNErrorMessage err;
            Info info1 = SvnKitDiffClient.this.myVcs.getInfo(this.myTarget2.getFile(), SVNRevision.HEAD);
            if (info1 == null) {
                err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ENTRY_NOT_FOUND, (String)"''{0}'' is not under version control", (Object)this.myTarget2);
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.WC);
            } else if (info1.getURL() == null) {
                err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ENTRY_MISSING_URL, (String)"''{0}'' has no URL", (Object)this.myTarget2);
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.WC);
            }
            SVNReporter17 reporter17 = new SVNReporter17(this.myTarget2.getFile(), new SVNWCContext(SvnKitDiffClient.this.myVcs.getSvnKitManager().getSvnOptions(), new ISVNEventHandler(){

                public void handleEvent(SVNEvent event, double progress) throws SVNException {
                }

                public void checkCancelled() throws SVNCancelException {
                }
            }), false, true, SVNDepth.INFINITY, false, false, true, false, SVNDebugLog.getDefaultLog());
            SVNRepository repository = null;
            SVNRepository repository2 = null;
            try {
                repository = SvnKitDiffClient.this.myVcs.getSvnKitManager().createRepository(info1.getURL());
                long rev = repository.getLatestRevision();
                repository2 = SvnKitDiffClient.this.myVcs.getSvnKitManager().createRepository(this.myTarget1.getURL());
                SvnDiffEditor diffEditor = new SvnDiffEditor(this.myTarget2.getFile(), repository2, rev, true);
                repository.diff(this.myTarget1.getURL(), rev, rev, null, true, SVNDepth.INFINITY, false, (ISVNReporterBaton)reporter17, SVNCancellableEditor.newInstance((ISVNEditor)diffEditor, (ISVNCanceller)new SvnKitProgressCanceller(), null));
                Collection<Change> collection = diffEditor.getChangesMap().values();
                return collection;
            }
            finally {
                if (repository != null) {
                    repository.closeSession();
                }
                if (repository2 != null) {
                    repository2.closeSession();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection<Change> run16Diff() throws SVNException {
            SVNWCAccess wcAccess = SVNWCAccess.newInstance(null);
            wcAccess.setOptions(SvnKitDiffClient.this.myVcs.getSvnKitManager().getSvnOptions());
            SVNRepository repository = null;
            SVNRepository repository2 = null;
            try {
                SVNErrorMessage err;
                SVNAdminAreaInfo info = wcAccess.openAnchor(this.myTarget2.getFile(), false, -1);
                File anchorPath = info.getAnchor().getRoot();
                String target = "".equals(info.getTargetName()) ? null : info.getTargetName();
                SVNEntry anchorEntry = info.getAnchor().getEntry("", false);
                if (anchorEntry == null) {
                    err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ENTRY_NOT_FOUND, (String)"''{0}'' is not under version control", (Object)anchorPath);
                    SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.WC);
                } else if (anchorEntry.getURL() == null) {
                    err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ENTRY_MISSING_URL, (String)"''{0}'' has no URL", (Object)anchorPath);
                    SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.WC);
                }
                SVNURL anchorURL = anchorEntry.getSVNURL();
                SVNReporter reporter = new SVNReporter(info, info.getAnchor().getFile(info.getTargetName()), false, true, SVNDepth.INFINITY, false, false, true, SVNDebugLog.getDefaultLog());
                repository = SvnKitDiffClient.this.myVcs.getSvnKitManager().createRepository(anchorURL.toString());
                long rev = repository.getLatestRevision();
                repository2 = SvnKitDiffClient.this.myVcs.getSvnKitManager().createRepository(target == null ? this.myTarget1.getURL() : this.myTarget1.getURL().removePathTail());
                SvnDiffEditor diffEditor = new SvnDiffEditor(target == null ? this.myTarget2.getFile() : this.myTarget2.getFile().getParentFile(), repository2, rev, true);
                repository.diff(this.myTarget1.getURL(), rev, rev, target, true, true, false, (ISVNReporterBaton)reporter, SVNCancellableEditor.newInstance((ISVNEditor)diffEditor, (ISVNCanceller)new SvnKitProgressCanceller(), null));
                Collection<Change> collection = diffEditor.getChangesMap().values();
                return collection;
            }
            finally {
                wcAccess.close();
                if (repository != null) {
                    repository.closeSession();
                }
                if (repository2 != null) {
                    repository2.closeSession();
                }
            }
        }
    }
}

