/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.diff;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.branchConfig.SelectBranchPopup;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.diff.DirectoryWithBranchComparer;
import org.jetbrains.idea.svn.diff.ElementWithBranchComparer;
import org.jetbrains.idea.svn.diff.FileWithBranchComparer;

public class CompareWithBranchAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        assert (project != null);
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        SelectBranchPopup.show(project, virtualFile, new MyBranchSelectedCallback(virtualFile), SvnBundle.message("compare.with.branch.popup.title", new Object[0]));
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        e.getPresentation().setEnabled(CompareWithBranchAction.isEnabled(project, virtualFile));
    }

    private static boolean isEnabled(Project project, VirtualFile virtualFile) {
        if (project == null || virtualFile == null) {
            return false;
        }
        FileStatus fileStatus = FileStatusManager.getInstance((Project)project).getStatus(virtualFile);
        return fileStatus != FileStatus.UNKNOWN && fileStatus != FileStatus.ADDED && fileStatus != FileStatus.IGNORED;
    }

    private static class MyBranchSelectedCallback
    implements SelectBranchPopup.BranchSelectedCallback {
        @NotNull
        private final VirtualFile myVirtualFile;

        public MyBranchSelectedCallback(@NotNull VirtualFile virtualFile) {
            this.myVirtualFile = virtualFile;
        }

        @Override
        public void branchSelected(Project project, SvnBranchConfigurationNew configuration, String url, long revision) {
            ElementWithBranchComparer comparer = this.myVirtualFile.isDirectory() ? new DirectoryWithBranchComparer(project, this.myVirtualFile, url, revision) : new FileWithBranchComparer(project, this.myVirtualFile, url, revision);
            comparer.run();
        }
    }
}

