/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browserCache;

import com.intellij.openapi.components.ServiceManager;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;
import org.jetbrains.idea.svn.dialogs.browserCache.Loader;
import org.jetbrains.idea.svn.dialogs.browserCache.NodeLoadState;
import org.jetbrains.idea.svn.dialogs.browserCache.RepositoryLoader;
import org.jetbrains.idea.svn.dialogs.browserCache.SvnRepositoryCache;

public class CacheLoader
extends Loader {
    @NotNull
    private final Loader myRepositoryLoader;

    public static Loader getInstance() {
        return (Loader)ServiceManager.getService(Loader.class);
    }

    public CacheLoader() {
        super(SvnRepositoryCache.getInstance());
        this.myRepositoryLoader = new RepositoryLoader(this.myCache);
    }

    @Override
    public void load(final @NotNull RepositoryTreeNode node, final @NotNull Expander expander) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String error;
                String nodeUrl = node.getURL().toString();
                List<DirectoryEntry> cached = CacheLoader.this.myCache.getChildren(nodeUrl);
                if (cached != null) {
                    CacheLoader.this.refreshNode(node, cached, expander);
                }
                if ((error = CacheLoader.this.myCache.getError(nodeUrl)) != null) {
                    CacheLoader.this.refreshNodeError(node, error);
                }
                CacheLoader.this.myRepositoryLoader.load(node, expander);
            }
        });
    }

    @Override
    @NotNull
    protected NodeLoadState getNodeLoadState() {
        return NodeLoadState.CACHED;
    }
}

