/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class WCInfoWithBranches
extends WCInfo {
    @NotNull
    private final List<Branch> myBranches;
    @NotNull
    private final VirtualFile myRoot;
    private final Branch myCurrentBranch;

    public WCInfoWithBranches(@NotNull WCInfo info, @NotNull List<Branch> branches, @NotNull VirtualFile root, Branch currentBranch) {
        super(info.getRootInfo(), info.isIsWcRoot(), info.getStickyDepth());
        this.myBranches = branches;
        this.myRoot = root;
        this.myCurrentBranch = currentBranch;
    }

    public String toString() {
        return this.getPath();
    }

    @Override
    @NotNull
    public VirtualFile getVcsRoot() {
        return this.myRoot;
    }

    @NotNull
    public List<Branch> getBranches() {
        return this.myBranches;
    }

    @NotNull
    public VirtualFile getRoot() {
        return this.myRoot;
    }

    public Branch getCurrentBranch() {
        return this.myCurrentBranch;
    }

    public static class Branch {
        @NotNull
        private final String myName;
        @NotNull
        private final String myUrl;

        public Branch(@NotNull String url) {
            this.myName = SVNPathUtil.tail((String)url);
            this.myUrl = url;
        }

        @NotNull
        public String getName() {
            return this.myName;
        }

        @NotNull
        public String getUrl() {
            return this.myUrl;
        }

        public String toString() {
            return this.myName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Branch branch = (Branch)o;
            return this.myUrl.equals(branch.myUrl);
        }

        public int hashCode() {
            return this.myUrl.hashCode();
        }
    }
}

