/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;

public class SvnFormatWorker
extends Task.Backgroundable {
    private static final Logger LOG = Logger.getInstance(SvnFormatWorker.class);
    private List<Throwable> myExceptions;
    private final Project myProject;
    @NotNull
    private final WorkingCopyFormat myNewFormat;
    private final List<WCInfo> myWcInfos;
    private List<LocalChangeList> myBeforeChangeLists;
    private final SvnVcs myVcs;

    public SvnFormatWorker(Project project, @NotNull WorkingCopyFormat newFormat, List<WCInfo> wcInfos) {
        super(project, SvnBundle.message("action.change.wcopy.format.task.title", new Object[0]), false, DEAF);
        this.myProject = project;
        this.myNewFormat = newFormat;
        this.myExceptions = new ArrayList<Throwable>();
        this.myWcInfos = wcInfos;
        this.myVcs = SvnVcs.getInstance(this.myProject);
    }

    public SvnFormatWorker(Project project, @NotNull WorkingCopyFormat newFormat, WCInfo wcInfo) {
        this(project, newFormat, Collections.singletonList(wcInfo));
    }

    public boolean haveStuffToConvert() {
        return !this.myWcInfos.isEmpty();
    }

    public void onCancel() {
        this.onSuccess();
    }

    public void onSuccess() {
        if (this.myProject.isDisposed()) {
            return;
        }
        if (!this.myExceptions.isEmpty()) {
            ArrayList<String> messages = new ArrayList<String>();
            for (Throwable exception : this.myExceptions) {
                messages.add(exception.getMessage());
            }
            AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(Collections.singletonList(new VcsException(messages)), SvnBundle.message("action.change.wcopy.format.task.title", new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull ProgressIndicator indicator) {
        ProjectLevelVcsManager.getInstanceChecked((Project)this.myProject).startBackgroundVcsOperation();
        indicator.setIndeterminate(true);
        boolean supportsChangelists = this.myNewFormat.supportsChangelists();
        if (supportsChangelists) {
            this.myBeforeChangeLists = ChangeListManager.getInstance((Project)this.myProject).getChangeListsCopy();
        }
        try {
            for (WCInfo wcInfo : this.myWcInfos) {
                File path = new File(wcInfo.getPath());
                if (!wcInfo.isIsWcRoot()) {
                    path = SvnUtil.getWorkingCopyRoot(path);
                }
                try {
                    String cleanupMessage = SvnBundle.message("action.Subversion.cleanup.progress.text", path.getAbsolutePath());
                    String upgradeMessage = SvnBundle.message("action.change.wcopy.format.task.progress.text", new Object[]{path.getAbsolutePath(), wcInfo.getFormat(), this.myNewFormat});
                    ProgressTracker handler = SvnFormatWorker.createUpgradeHandler(indicator, cleanupMessage, upgradeMessage);
                    this.getFactory(path, this.myNewFormat).createUpgradeClient().upgrade(path, this.myNewFormat, handler);
                }
                catch (Throwable e) {
                    this.myExceptions.add(e);
                }
            }
        }
        finally {
            ProjectLevelVcsManager.getInstance((Project)this.myProject).stopBackgroundVcsOperation();
            if (supportsChangelists) {
                SvnVcs.getInstance(this.myProject).processChangeLists(this.myBeforeChangeLists);
            }
            ((Runnable)ApplicationManager.getApplication().getMessageBus().syncPublisher(SvnVcs.WC_CONVERTED)).run();
        }
    }

    @NotNull
    private ClientFactory getFactory(@NotNull File path, @NotNull WorkingCopyFormat format) throws VcsException {
        ClientFactory factory = this.myVcs.getFactory(path);
        ClientFactory otherFactory = this.myVcs.getOtherFactory(factory);
        List<WorkingCopyFormat> factoryFormats = factory.createUpgradeClient().getSupportedFormats();
        List<WorkingCopyFormat> otherFactoryFormats = SvnFormatWorker.getOtherFactoryFormats(otherFactory);
        return factoryFormats.contains((Object)format) || !otherFactoryFormats.contains((Object)format) ? factory : otherFactory;
    }

    public static List<WorkingCopyFormat> getOtherFactoryFormats(@NotNull ClientFactory otherFactory) {
        ArrayList result;
        try {
            result = otherFactory.createUpgradeClient().getSupportedFormats();
        }
        catch (VcsException e) {
            result = ContainerUtil.newArrayList();
            LOG.info("Failed to get upgrade formats from other factory", (Throwable)e);
        }
        return result;
    }

    private static ProgressTracker createUpgradeHandler(final @NotNull ProgressIndicator indicator, final @NotNull String cleanupMessage, final @NotNull String upgradeMessage) {
        return new ProgressTracker(){

            public void consume(ProgressEvent event) throws SVNException {
                if (event.getFile() != null) {
                    if (EventAction.UPGRADED_PATH.equals((Object)event.getAction())) {
                        indicator.setText2("Upgraded path " + VcsUtil.getPathForProgressPresentation((File)event.getFile()));
                    }
                    if (EventAction.UPDATE_STARTED.equals((Object)event.getAction())) {
                        indicator.setText(cleanupMessage);
                    }
                    if (EventAction.UPDATE_COMPLETED.equals((Object)event.getAction())) {
                        indicator.setText(upgradeMessage);
                    }
                }
            }

            @Override
            public void checkCancelled() throws SVNCancelException {
                indicator.checkCanceled();
            }
        };
    }
}

