/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.copy;

import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.checkin.CommitEventHandler;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.copy.CopyMoveClient;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnKitCopyMoveClient
extends BaseSvnClient
implements CopyMoveClient {
    private static final int INVALID_REVISION = -1;

    @Override
    public void copy(@NotNull File src, @NotNull File dst, boolean makeParents, boolean isMove) throws VcsException {
        SVNCopySource copySource = new SVNCopySource(isMove ? SVNRevision.UNDEFINED : SVNRevision.WORKING, SVNRevision.WORKING, src);
        try {
            this.myVcs.getSvnKitManager().createCopyClient().doCopy(new SVNCopySource[]{copySource}, dst, isMove, makeParents, true);
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
    }

    @Override
    public long copy(@NotNull SvnTarget source, @NotNull SvnTarget destination, @Nullable SVNRevision revision, boolean makeParents, boolean isMove, @NotNull String message, @Nullable CommitEventHandler handler) throws VcsException {
        SVNCommitInfo info;
        if (!destination.isURL()) {
            throw new IllegalArgumentException("Only urls are supported as destination " + destination);
        }
        SVNCopySource copySource = SvnKitCopyMoveClient.createCopySource(source, revision);
        SVNCopyClient client = this.myVcs.getSvnKitManager().createCopyClient();
        client.setEventHandler(SvnKitCopyMoveClient.toEventHandler(handler));
        try {
            info = client.doCopy(new SVNCopySource[]{copySource}, destination.getURL(), isMove, makeParents, true, message, null);
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
        return info != null ? info.getNewRevision() : -1L;
    }

    @Override
    public void copy(@NotNull SvnTarget source, @NotNull File destination, @Nullable SVNRevision revision, boolean makeParents, @Nullable ProgressTracker handler) throws VcsException {
        SVNCopyClient client = this.myVcs.getSvnKitManager().createCopyClient();
        client.setEventHandler(SvnKitCopyMoveClient.toEventHandler(handler));
        try {
            client.doCopy(new SVNCopySource[]{SvnKitCopyMoveClient.createCopySource(source, revision)}, destination, false, makeParents, true);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @NotNull
    private static SVNCopySource createCopySource(@NotNull SvnTarget source, @Nullable SVNRevision revision) {
        return source.isFile() ? new SVNCopySource(source.getPegRevision(), revision, source.getFile()) : new SVNCopySource(source.getPegRevision(), revision, source.getURL());
    }
}

