/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.content;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.content.ContentClient;
import org.jetbrains.idea.svn.content.FileTooBigRuntimeException;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdContentClient
extends BaseSvnClient
implements ContentClient {
    private static final Logger LOG = Logger.getInstance(CmdContentClient.class);
    private static final String NO_PRISTINE_VERSION_FOR_FILE = "has no pristine version until it is committed";

    @Override
    public byte[] getContent(@NotNull SvnTarget target, @Nullable SVNRevision revision, @Nullable SVNRevision pegRevision) throws VcsException, FileTooBigRuntimeException {
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, target.getPathOrUrlString(), pegRevision);
        CommandUtil.put(parameters, revision);
        CommandExecutor command = null;
        try {
            command = this.execute(this.myVcs, target, SvnCommandName.cat, parameters, null);
        }
        catch (SvnBindException e) {
            if (StringUtil.containsIgnoreCase((String)e.getMessage(), (String)NO_PRISTINE_VERSION_FOR_FILE)) {
                LOG.debug((Throwable)((Object)e));
            }
            throw e;
        }
        byte[] bytes = command != null ? command.getBinaryOutput().toByteArray() : ArrayUtil.EMPTY_BYTE_ARRAY;
        ContentRevisionCache.checkContentsSize((String)target.getPathOrUrlString(), (long)bytes.length);
        return bytes;
    }
}

