/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.conflict;

import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public enum ConflictReason {
    EDITED("edit", "edited"),
    OBSTRUCTED("obstruction", "obstruct", "obstructed"),
    DELETED("delete", "deleted"),
    MISSING("missing", "miss"),
    UNVERSIONED("unversioned", "unversion"),
    ADDED("add", "added"),
    REPLACED("replace", "replaced"),
    MOVED_AWAY("moved-away", new String[0]),
    MOVED_HERE("moved-here", new String[0]);

    @NotNull
    private static final Map<String, ConflictReason> ourAllReasons;
    @NotNull
    private final String myKey;
    @NotNull
    private final String[] myOtherKeys;

    private ConflictReason(String key, String ... otherKeys) {
        this.myKey = key;
        this.myOtherKeys = otherKeys;
    }

    public String toString() {
        return this.myKey;
    }

    private static void register(@NotNull ConflictReason reason) {
        ourAllReasons.put(reason.myKey, reason);
        for (String key : reason.myOtherKeys) {
            ourAllReasons.put(key, reason);
        }
    }

    @NotNull
    public static ConflictReason from(@NotNull String reasonName) {
        ConflictReason result = ourAllReasons.get(reasonName);
        if (result == null) {
            throw new IllegalArgumentException("Unknown conflict reason " + reasonName);
        }
        return result;
    }

    static {
        ourAllReasons = ContainerUtil.newHashMap();
        for (ConflictReason reason : ConflictReason.values()) {
            ConflictReason.register(reason);
        }
    }
}

