/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkin;

import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tmatesoft.svn.core.SVNErrorMessage;

public class CommitInfo {
    public static final CommitInfo EMPTY = new Builder().setRevision(-1L).build();
    private final long myRevision;
    private final Date myDate;
    private final String myAuthor;
    @Nullable
    private final SVNErrorMessage myErrorMessage;

    private CommitInfo(@NotNull Builder builder) {
        this.myRevision = builder.revision;
        this.myAuthor = builder.author;
        this.myDate = builder.date;
        this.myErrorMessage = builder.error;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    public Date getDate() {
        return this.myDate;
    }

    @Nullable
    public SVNErrorMessage getErrorMessage() {
        return this.myErrorMessage;
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    @XmlType(name="commit")
    @XmlRootElement(name="commit")
    public static class Builder {
        @XmlAttribute(name="revision")
        private long revision;
        @XmlElement(name="author")
        private String author;
        @XmlElement(name="date")
        private Date date;
        @Nullable
        private SVNErrorMessage error;

        public Builder() {
        }

        public Builder(long revision, Date date, String author) {
            this.revision = revision;
            this.date = date;
            this.author = author;
        }

        public long getRevision() {
            return this.revision;
        }

        public String getAuthor() {
            return this.author;
        }

        public Date getDate() {
            return this.date;
        }

        @NotNull
        public Builder setRevision(long revision) {
            this.revision = revision;
            return this;
        }

        @NotNull
        public Builder setAuthor(String author) {
            this.author = author;
            return this;
        }

        @NotNull
        public Builder setDate(Date date) {
            this.date = date;
            return this;
        }

        @NotNull
        public Builder setError(@Nullable SVNErrorMessage error) {
            this.error = error;
            return this;
        }

        @NotNull
        public CommitInfo build() {
            return new CommitInfo(this);
        }
    }
}

