/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlPair;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class UniqueRootsFilter {
    public <T extends RootUrlPair> List<T> filter(@NotNull List<T> list) {
        ArrayList<RootUrlPair> result = new ArrayList<RootUrlPair>();
        UniqueRootsFilter.sort(list);
        for (RootUrlPair child : list) {
            if (UniqueRootsFilter.alreadyRegistered(child, result)) continue;
            result.add(child);
        }
        return result;
    }

    private static <T extends RootUrlPair> void sort(List<T> list) {
        Collections.sort(list, new Comparator<RootUrlPair>(){

            @Override
            public int compare(RootUrlPair o1, RootUrlPair o2) {
                return o1.getVirtualFile().getPath().compareTo(o2.getVirtualFile().getPath());
            }
        });
    }

    private static <T extends RootUrlPair> boolean alreadyRegistered(final @NotNull T child, @NotNull List<T> registered) {
        return ContainerUtil.exists(registered, (Condition)new Condition<T>(){

            public boolean value(T parent) {
                return UniqueRootsFilter.isSamePath(child, parent) || UniqueRootsFilter.isSameSupposedUrl(child, parent);
            }
        });
    }

    private static <T extends RootUrlPair> boolean isSamePath(@NotNull T child, @NotNull T parent) {
        return parent.getVirtualFile().getPath().equals(child.getVirtualFile().getPath());
    }

    private static <T extends RootUrlPair> boolean isSameSupposedUrl(@NotNull T child, @NotNull T parent) {
        boolean result = false;
        if (VfsUtilCore.isAncestor((VirtualFile)parent.getVirtualFile(), (VirtualFile)child.getVirtualFile(), (boolean)true)) {
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)child.getVirtualFile(), (VirtualFile)parent.getVirtualFile(), (char)'/');
            String supposed = UniqueRootsFilter.getSupposedUrl(parent.getUrl(), relativePath);
            if (supposed.equals(child.getUrl())) {
                result = true;
            }
        }
        return result;
    }

    @Nullable
    private static String getSupposedUrl(String parentUrl, String relativePath) {
        if (parentUrl == null) {
            return null;
        }
        return SVNPathUtil.append((String)parentUrl, (String)relativePath);
    }
}

