/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;

public class SvnFormatSelector {
    @NotNull
    public static WorkingCopyFormat findRootAndGetFormat(File path) {
        File root = SvnUtil.getWorkingCopyRootNew(path);
        return root != null ? SvnFormatSelector.getWorkingCopyFormat(root) : WorkingCopyFormat.UNKNOWN;
    }

    @NotNull
    public static WorkingCopyFormat getWorkingCopyFormat(File path) {
        WorkingCopyFormat format = SvnUtil.getFormat(path);
        return WorkingCopyFormat.UNKNOWN.equals((Object)format) ? SvnFormatSelector.detectWithSvnKit(path) : format;
    }

    @NotNull
    private static WorkingCopyFormat detectWithSvnKit(File path) {
        try {
            SvnWcGeneration svnWcGeneration = SvnOperationFactory.detectWcGeneration((File)path, (boolean)true);
            if (SvnWcGeneration.V17.equals((Object)svnWcGeneration)) {
                return WorkingCopyFormat.ONE_DOT_SEVEN;
            }
        }
        catch (SVNException svnWcGeneration) {
            // empty catch block
        }
        int format = 0;
        try {
            format = SVNAdminAreaFactory.checkWC((File)path, (boolean)false);
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        try {
            if (format == 0 && path.getParentFile() != null) {
                format = SVNAdminAreaFactory.checkWC((File)path.getParentFile(), (boolean)false);
            }
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        return WorkingCopyFormat.getInstance(format);
    }
}

