/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLQuotedText;
import org.jetbrains.yaml.psi.impl.YAMLScalarImpl;

public class YAMLQuotedTextImpl
extends YAMLScalarImpl
implements YAMLQuotedText {
    private final boolean myIsSingleQuoted = this.getNode().getFirstChildNode().getElementType() == YAMLTokenTypes.SCALAR_STRING;

    public YAMLQuotedTextImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public List<TextRange> getContentRanges() {
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        List lines = StringUtil.split((String)this.getText(), (String)"\n", (boolean)true, (boolean)false);
        int cumulativeOffset = 0;
        for (int i = 0; i < lines.size(); ++i) {
            int lineStart;
            String line = (String)lines.get(i);
            int lineEnd = line.length();
            if (i == 0) {
                ++lineStart;
            } else {
                for (lineStart = 0; lineStart < line.length() && Character.isWhitespace(line.charAt(lineStart)); ++lineStart) {
                }
            }
            if (i == lines.size() - 1) {
                --lineEnd;
            } else {
                while (lineEnd > lineStart && Character.isWhitespace(line.charAt(lineEnd - 1))) {
                    --lineEnd;
                }
            }
            result.add(TextRange.create((int)lineStart, (int)lineEnd).shiftRight(cumulativeOffset));
            cumulativeOffset += line.length() + 1;
        }
        return result;
    }

    @Override
    @NotNull
    protected String getRangesJoiner(@NotNull CharSequence leftString, @NotNull CharSequence rightString) {
        if (leftString.length() == 0 || !this.isSingleQuote() && leftString.charAt(leftString.length() - 1) == '\\') {
            return "\n";
        }
        if (rightString.length() == 0) {
            return "";
        }
        return " ";
    }

    @Override
    @NotNull
    public String getTextValue() {
        String gluedText = super.getTextValue();
        if (this.isSingleQuote()) {
            return StringUtil.replace((String)gluedText, (String)"''", (String)"'");
        }
        String trimmedEndEscapes = StringUtil.replace((String)gluedText, (String[])new String[]{"\\\n", "\\ "}, (String[])new String[]{"", " "});
        return StringUtil.replaceUnicodeEscapeSequences((String)trimmedEndEscapes);
    }

    @Override
    public boolean isMultiline() {
        return this.getText().contains("\n");
    }

    @Override
    public boolean isSingleQuote() {
        return this.myIsSingleQuoted;
    }

    @Override
    public String toString() {
        return "YAML quoted text";
    }
}

