/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementTypes;

public class YAMLFoldingBuilder
implements FoldingBuilder,
DumbAware {
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode astNode, @NotNull Document document) {
        LinkedList<FoldingDescriptor> descriptors = new LinkedList<FoldingDescriptor>();
        YAMLFoldingBuilder.collectDescriptors(astNode, descriptors);
        return descriptors.toArray(new FoldingDescriptor[descriptors.size()]);
    }

    private static void collectDescriptors(@NotNull ASTNode node, @NotNull List<FoldingDescriptor> descriptors) {
        IElementType type = node.getElementType();
        TextRange nodeTextRange = node.getTextRange();
        if (!StringUtil.isEmptyOrSpaces((String)node.getText()) && nodeTextRange.getLength() >= 2) {
            ASTNode valueNode;
            if (type == YAMLElementTypes.KEY_VALUE_PAIR && (valueNode = node.findChildByType((IElementType)YAMLElementTypes.COMPOUND_VALUE)) != null && !StringUtil.isEmpty((String)valueNode.getText().trim())) {
                descriptors.add(new FoldingDescriptor(node, nodeTextRange));
            }
            if (type == YAMLElementTypes.DOCUMENT && node.getTreeParent().getChildren(TokenSet.create((IElementType[])new IElementType[]{YAMLElementTypes.DOCUMENT})).length > 1) {
                descriptors.add(new FoldingDescriptor(node, nodeTextRange));
            }
            if (type == YAMLElementTypes.SCALAR_TEXT_VALUE || type == YAMLElementTypes.SCALAR_LIST_VALUE || type == YAMLElementTypes.SCALAR_PLAIN_VALUE) {
                descriptors.add(new FoldingDescriptor(node, nodeTextRange));
            }
        }
        for (ASTNode child : node.getChildren(null)) {
            YAMLFoldingBuilder.collectDescriptors(child, descriptors);
        }
    }

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        IElementType type = node.getElementType();
        if (type == YAMLElementTypes.DOCUMENT) {
            return "---";
        }
        if (type == YAMLElementTypes.KEY_VALUE_PAIR) {
            return node.getFirstChildNode().getText();
        }
        if (type == YAMLElementTypes.SCALAR_TEXT_VALUE || type == YAMLElementTypes.SCALAR_LIST_VALUE) {
            return node.getText().substring(0, 1);
        }
        return "...";
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        return false;
    }
}

