/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.upgrade;

import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.checkout.SvnKitCheckoutClient;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.upgrade.UpgradeClient;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SvnKitUpgradeClient
extends BaseSvnClient
implements UpgradeClient {
    @Override
    public void upgrade(@NotNull File path, @NotNull WorkingCopyFormat format, @Nullable ProgressTracker handler) throws VcsException {
        this.validateFormat(format, this.getSupportedFormats());
        SVNWCClient client = this.myVcs.getSvnKitManager().createUpgradeClient();
        client.setEventHandler(SvnKitUpgradeClient.toEventHandler(handler));
        try {
            SvnKitUpgradeClient.cleanupIfNecessary(path, format, client, handler);
            SvnKitUpgradeClient.upgrade(path, format, client, handler);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @Override
    public List<WorkingCopyFormat> getSupportedFormats() throws VcsException {
        return SvnKitCheckoutClient.SUPPORTED_FORMATS;
    }

    private static void cleanupIfNecessary(@NotNull File path, @NotNull WorkingCopyFormat format, @NotNull SVNWCClient client, @Nullable ProgressTracker handler) throws SVNException, VcsException {
        if (WorkingCopyFormat.ONE_DOT_SEVEN.equals((Object)format)) {
            SvnKitUpgradeClient.callHandler(handler, SvnKitUpgradeClient.createEvent(path, EventAction.UPDATE_STARTED));
            client.doCleanup(path);
        }
    }

    private static void upgrade(@NotNull File path, @NotNull WorkingCopyFormat format, @NotNull SVNWCClient client, @Nullable ProgressTracker handler) throws SVNException, VcsException {
        SvnKitUpgradeClient.callHandler(handler, SvnKitUpgradeClient.createEvent(path, EventAction.UPDATE_COMPLETED));
        client.doSetWCFormat(path, format.getFormat());
    }
}

