/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.statistics;

import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.statistics.VcsUsagesCollector;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnVcs;

public class SvnWorkingCopyFormatUsagesCollector
extends VcsUsagesCollector {
    private static final String GROUP_ID = "svn working copy format";

    @NotNull
    public GroupDescriptor getGroupId() {
        return GroupDescriptor.create((String)GROUP_ID, (double)100.0);
    }

    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) {
        SvnVcs vcs = SvnVcs.getInstance(project);
        List roots = ContainerUtil.filter(vcs.getSvnFileUrlMapping().getAllWcInfos(), (Condition)new Condition<RootUrlInfo>(){

            public boolean value(RootUrlInfo info) {
                return info.getType() == null || NestedCopyType.inner.equals((Object)info.getType());
            }
        });
        return ContainerUtil.map2Set((Collection)roots, (Function)new Function<RootUrlInfo, UsageDescriptor>(){

            public UsageDescriptor fun(RootUrlInfo info) {
                return new UsageDescriptor(info.getFormat().toString(), 1);
            }
        });
    }
}

