/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.lock;

import com.intellij.openapi.vcs.changes.LogicalLock;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tmatesoft.svn.core.SVNLock;

public class Lock {
    private final String myOwner;
    private final String myComment;
    private final Date myCreationDate;
    @Nullable
    private final Date myExpirationDate;

    @Nullable
    public static Lock create(@Nullable SVNLock lock) {
        Lock result = null;
        if (lock != null) {
            result = new Builder().setOwner(lock.getOwner()).setComment(lock.getComment()).setCreationDate(lock.getCreationDate()).setExpirationDate(lock.getExpirationDate()).build();
        }
        return result;
    }

    public Lock(@NotNull Builder builder) {
        this.myOwner = builder.owner;
        this.myComment = builder.comment;
        this.myCreationDate = builder.created;
        this.myExpirationDate = builder.expires;
    }

    public String getComment() {
        return this.myComment;
    }

    public Date getCreationDate() {
        return this.myCreationDate;
    }

    @Nullable
    public Date getExpirationDate() {
        return this.myExpirationDate;
    }

    public String getOwner() {
        return this.myOwner;
    }

    @NotNull
    public LogicalLock toLogicalLock(boolean isLocal) {
        return new LogicalLock(isLocal, this.myOwner, this.myComment, this.myCreationDate, this.myExpirationDate);
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    @XmlType(name="lock")
    @XmlRootElement(name="lock")
    public static class Builder {
        @XmlElement(name="token")
        private String token;
        @XmlElement(name="owner")
        private String owner;
        @XmlElement(name="comment")
        private String comment;
        @XmlElement(name="created")
        private Date created;
        @XmlElement(name="expires")
        @Nullable
        private Date expires;

        @NotNull
        public Builder setToken(String token) {
            this.token = token;
            return this;
        }

        @NotNull
        public Builder setOwner(String owner) {
            this.owner = owner;
            return this;
        }

        @NotNull
        public Builder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @NotNull
        public Builder setCreationDate(Date creationDate) {
            this.created = creationDate;
            return this;
        }

        @NotNull
        public Builder setExpirationDate(@Nullable Date expirationDate) {
            this.expires = expirationDate;
            return this;
        }

        @NotNull
        public Lock build() {
            return new Lock(this);
        }
    }
}

