/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.Where;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.Intersection;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;

public class ShelveLocalChangesTask
extends BaseMergeTask {
    @NotNull
    private final Intersection myIntersection;

    public ShelveLocalChangesTask(@NotNull MergeContext mergeContext, @NotNull QuickMergeInteraction interaction, @NotNull Intersection intersection) {
        super(mergeContext, interaction, "Shelving local changes before merge", Where.POOLED);
        this.myIntersection = intersection;
    }

    public void run(final ContinuationContext context) {
        List<VirtualFile> changedFiles = this.shelveChanges(context);
        context.suspend();
        RefreshQueue.getInstance().refresh(true, false, new Runnable(){

            @Override
            public void run() {
                context.ping();
            }
        }, changedFiles);
    }

    @NotNull
    private List<VirtualFile> shelveChanges(@NotNull ContinuationContext context) {
        ArrayList changedFiles = ContainerUtil.newArrayList();
        ShelveChangesManager shelveManager = ShelveChangesManager.getInstance((Project)this.myMergeContext.getProject());
        for (Map.Entry entry : this.myIntersection.getChangesSubset().entrySet()) {
            try {
                ShelveLocalChangesTask.saveAllDocuments();
                shelveManager.shelveChanges((Collection)entry.getValue(), this.myIntersection.getComment((String)entry.getKey()) + " (auto shelve before merge)", true);
                ContainerUtil.addAll((Collection)changedFiles, (Object[])ChangesUtil.getFilesFromChanges((Collection)((Collection)entry.getValue())));
            }
            catch (IOException e) {
                this.finishWithError(context, e.getMessage(), true);
            }
            catch (VcsException e) {
                this.finishWithError(context, e.getMessage(), true);
            }
        }
        return changedFiles;
    }

    private static void saveAllDocuments() {
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                FileDocumentManager.getInstance().saveAllDocuments();
            }
        }, ModalityState.NON_MODAL);
    }
}

