/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.UpdateFilesHelper;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.SvnMergeProvider;

public class ResolveWorker {
    private final boolean myChangesUnderProjectRoot;
    private final Project myProject;
    private final VcsDirtyScopeManager myDirtyScopeManager;
    private List<VirtualFile> myConflictedVirtualFiles;

    public ResolveWorker(boolean changesUnderProjectRoot, Project project) {
        this.myChangesUnderProjectRoot = changesUnderProjectRoot;
        this.myProject = project;
        this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project);
        this.myConflictedVirtualFiles = new ArrayList<VirtualFile>();
    }

    private void refreshChangeListsFindConflicts(UpdatedFiles updatedFiles) {
        UpdateFilesHelper.iterateFileGroupFiles((UpdatedFiles)updatedFiles, (UpdateFilesHelper.Callback)new UpdateFilesHelper.Callback(){

            public void onFile(String filePath, String groupId) {
                VirtualFile vf = SvnUtil.getVirtualFile(filePath);
                if (vf != null) {
                    vf.getParent().refresh(false, false);
                    ResolveWorker.this.myDirtyScopeManager.fileDirty(vf);
                }
                if ("MERGED_WITH_CONFLICTS".equals(groupId)) {
                    ResolveWorker.this.myConflictedVirtualFiles.add(vf);
                }
            }
        });
    }

    public boolean needsInteraction(UpdatedFiles updatedFiles) {
        if (this.myChangesUnderProjectRoot) {
            this.refreshChangeListsFindConflicts(updatedFiles);
        } else {
            FileGroup conflictedGroup = updatedFiles.getGroupById("MERGED_WITH_CONFLICTS");
            for (String filename : conflictedGroup.getFiles()) {
                VirtualFile vf = SvnUtil.getVirtualFile(filename);
                this.myConflictedVirtualFiles.add(vf);
            }
        }
        return (!this.myConflictedVirtualFiles.isEmpty() || !ResolveWorker.haveUnresolvedConflicts(updatedFiles)) && !SvnConfiguration.getInstance(this.myProject).isMergeDryRun();
    }

    public static boolean haveUnresolvedConflicts(UpdatedFiles updatedFiles) {
        String[] ids;
        for (String id : ids = new String[]{"MERGED_WITH_CONFLICTS", "MERGED_WITH_PROPERTY_CONFLICT", "MERGED_WITH_TREE_CONFLICT", "SKIPPED"}) {
            FileGroup group = updatedFiles.getGroupById(id);
            if (group == null || group.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void execute(UpdatedFiles updatedFiles) {
        if (this.myConflictedVirtualFiles.isEmpty()) {
            return;
        }
        AbstractVcsHelper vcsHelper = AbstractVcsHelper.getInstance((Project)this.myProject);
        List mergedFiles = vcsHelper.showMergeDialog(this.myConflictedVirtualFiles, (MergeProvider)new SvnMergeProvider(this.myProject));
        FileGroup mergedGroup = updatedFiles.getGroupById("MERGED");
        FileGroup conflictedGroup = updatedFiles.getGroupById("MERGED_WITH_CONFLICTS");
        VcsKey vcsKey = SvnVcs.getKey();
        for (VirtualFile mergedFile : mergedFiles) {
            String path = FileUtil.toSystemDependentName((String)mergedFile.getPresentableUrl());
            conflictedGroup.remove(path);
            mergedGroup.add(path, vcsKey, null);
            mergedFile.refresh(false, false);
            mergedFile.getParent().refresh(false, false);
            if (!this.myChangesUnderProjectRoot) continue;
            this.myDirtyScopeManager.fileDirty(mergedFile);
        }
    }
}

