/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.TransparentlyFailedValueI;
import com.intellij.util.Consumer;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.CopyData;
import org.jetbrains.idea.svn.history.HistoryClient;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryConsumer;
import org.jetbrains.idea.svn.history.LogEntryPath;
import org.jetbrains.idea.svn.history.SvnPathThroughHistoryCorrection;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class FirstInBranch
implements Runnable {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.history.FirstInBranch");
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final String myBranchUrl;
    @NotNull
    private final String myTrunkUrl;
    @NotNull
    private final String myRepositoryRoot;
    @NotNull
    private final TransparentlyFailedValueI<CopyData, VcsException> myConsumer;

    public FirstInBranch(@NotNull SvnVcs vcs, @NotNull String repositoryRoot, @NotNull String branchUrl, @NotNull String trunkUrl, @NotNull TransparentlyFailedValueI<CopyData, VcsException> consumer) {
        this.myVcs = vcs;
        this.myRepositoryRoot = repositoryRoot;
        this.myConsumer = consumer;
        this.myBranchUrl = FirstInBranch.relativePath(repositoryRoot, branchUrl);
        this.myTrunkUrl = FirstInBranch.relativePath(repositoryRoot, trunkUrl);
    }

    private static String relativePath(String parent, String child) {
        String path = SVNPathUtil.getRelativePath((String)parent, (String)child);
        return SvnUtil.ensureStartSlash(path);
    }

    private SVNURL getRepositoryRootUrl() {
        SVNURL result = null;
        try {
            result = SvnUtil.createUrl(this.myRepositoryRoot);
        }
        catch (SvnBindException e) {
            LOG.info((Throwable)((Object)e));
            this.myConsumer.fail((Exception)((Object)e));
        }
        return result;
    }

    @Override
    public void run() {
        SVNURL repositoryRootUrl = this.getRepositoryRootUrl();
        if (repositoryRootUrl != null) {
            this.run(repositoryRootUrl);
        }
    }

    private void run(@NotNull SVNURL url) {
        try {
            this.run(url, new Consumer<CopyData>(){

                public void consume(CopyData data) {
                    if (data != null) {
                        FirstInBranch.this.myConsumer.set((Object)data);
                    }
                }
            });
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            this.myConsumer.fail((Exception)((Object)e));
        }
    }

    private void run(@NotNull SVNURL branchURL, @NotNull Consumer<CopyData> copyDataConsumer) throws VcsException {
        block3: {
            final SvnTarget target = SvnTarget.fromURL((SVNURL)branchURL);
            HistoryClient client = (HistoryClient)ApplicationManager.getApplication().runReadAction((Computable)new Computable<HistoryClient>(){

                public HistoryClient compute() {
                    if (FirstInBranch.this.myVcs.getProject().isDisposed()) {
                        return null;
                    }
                    return FirstInBranch.this.myVcs.getFactory(target).createHistoryClient();
                }
            });
            if (client == null) {
                return;
            }
            try {
                client.doLog(target, SVNRevision.HEAD, SVNRevision.create((long)0L), false, true, false, -1L, null, new MyLogEntryHandler(copyDataConsumer, this.myTrunkUrl, this.myBranchUrl));
            }
            catch (SvnBindException e) {
                if (e.contains(SVNErrorCode.CANCELLED)) break block3;
                throw e;
            }
        }
    }

    private static class MyLogEntryHandler
    implements LogEntryConsumer {
        @NotNull
        private final SvnPathThroughHistoryCorrection myTrunkCorrector;
        @NotNull
        private final SvnPathThroughHistoryCorrection myBranchCorrector;
        @NotNull
        private final Consumer<CopyData> myCopyDataConsumer;

        public MyLogEntryHandler(@NotNull Consumer<CopyData> copyDataConsumer, @NotNull String trunkUrl, @NotNull String branchUrl) {
            this.myCopyDataConsumer = copyDataConsumer;
            this.myTrunkCorrector = new SvnPathThroughHistoryCorrection(trunkUrl);
            this.myBranchCorrector = new SvnPathThroughHistoryCorrection(branchUrl);
        }

        public void consume(LogEntry logEntry) throws SVNException {
            Map<String, LogEntryPath> map = logEntry.getChangedPaths();
            this.checkEntries(logEntry, map);
            this.myTrunkCorrector.consume(logEntry);
            this.myBranchCorrector.consume(logEntry);
            this.checkEntries(logEntry, map);
        }

        private void checkEntries(LogEntry logEntry, Map map) throws SVNCancelException {
            for (Object o : map.values()) {
                LogEntryPath path = (LogEntryPath)o;
                String localPath = path.getPath();
                String copyPath = path.getCopyPath();
                if ('A' != path.getType() || !this.checkForCopyCase(logEntry, path, localPath, copyPath, this.myTrunkCorrector.getCurrentPath(), this.myBranchCorrector.getCurrentPath())) continue;
                throw new SVNCancelException();
            }
        }

        private boolean checkForCopyCase(LogEntry logEntry, LogEntryPath path, String localPath, String copyPath, String trunkUrl, String branchUrl) {
            if (MyLogEntryHandler.equalOrParent(localPath, branchUrl) && MyLogEntryHandler.equalOrParent(copyPath, trunkUrl)) {
                this.myCopyDataConsumer.consume((Object)new CopyData(path.getCopyRevision(), logEntry.getRevision(), true));
                return true;
            }
            if (MyLogEntryHandler.equalOrParent(copyPath, branchUrl) && MyLogEntryHandler.equalOrParent(localPath, trunkUrl)) {
                this.myCopyDataConsumer.consume((Object)new CopyData(path.getCopyRevision(), logEntry.getRevision(), false));
                return true;
            }
            return false;
        }

        private static boolean equalOrParent(String localPath, String targetPath) {
            return targetPath.equals(localPath) || SVNPathUtil.isAncestor((String)localPath, (String)targetPath);
        }
    }
}

