/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.diff;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.diff.ElementWithBranchComparer;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class DirectoryWithBranchComparer
extends ElementWithBranchComparer {
    @NotNull
    private final StringBuilder titleBuilder = new StringBuilder();
    @NotNull
    private final List<Change> changes = new ArrayList<Change>();

    public DirectoryWithBranchComparer(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull String branchUrl, long branchRevision) {
        super(project, virtualFile, branchUrl, branchRevision);
    }

    @Override
    protected void compare() throws SVNException, VcsException {
        this.titleBuilder.append(SvnBundle.message("repository.browser.compare.title", this.myElementUrl, FileUtil.toSystemDependentName((String)this.myVirtualFile.getPresentableUrl())));
        SvnTarget target1 = SvnTarget.fromURL((SVNURL)this.myElementUrl);
        SvnTarget target2 = SvnTarget.fromFile((File)new File(this.myVirtualFile.getPath()));
        this.changes.addAll(this.getClientFactory().createDiffClient().compare(target1, target2));
    }

    @NotNull
    private ClientFactory getClientFactory() {
        return DirectoryWithBranchComparer.getClientFactory(this.myVcs, VfsUtilCore.virtualToIoFile((VirtualFile)this.myVirtualFile));
    }

    @NotNull
    public static ClientFactory getClientFactory(@NotNull SvnVcs vcs, @NotNull File file) {
        WorkingCopyFormat format = vcs.getWorkingCopyFormat(file);
        return format.isOrGreater(WorkingCopyFormat.ONE_DOT_EIGHT) ? vcs.getCommandLineFactory() : vcs.getSvnKitFactory();
    }

    @Override
    protected void onCancel() {
        this.changes.clear();
    }

    @Override
    protected void showResult() {
        AbstractVcsHelper.getInstance((Project)this.myProject).showWhatDiffersBrowser(null, this.changes, this.titleBuilder.toString());
    }

    @Override
    public String getTitle() {
        return SvnBundle.message("progress.computing.difference", new Object[0]);
    }
}

