/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.diff;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnStatusConvertor;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.diff.DiffClient;
import org.jetbrains.idea.svn.history.SvnRepositoryContentRevision;
import org.jetbrains.idea.svn.status.SvnStatusHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdDiffClient
extends BaseSvnClient
implements DiffClient {
    @Override
    @NotNull
    public List<Change> compare(@NotNull SvnTarget target1, @NotNull SvnTarget target2) throws VcsException {
        this.assertUrl(target1);
        if (target2.isFile()) {
            this.assertDirectory(target2);
            WorkingCopyFormat format = WorkingCopyFormat.from(this.myFactory.createVersionClient().getVersion());
            if (format.less(WorkingCopyFormat.ONE_DOT_EIGHT)) {
                throw new SvnBindException("Could not compare local file and remote url with executable for svn " + (Object)((Object)format));
            }
        }
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, target1);
        CommandUtil.put(parameters, target2);
        parameters.add("--xml");
        parameters.add("--summarize");
        CommandExecutor executor = this.execute(this.myVcs, target1, SvnCommandName.diff, parameters, null);
        return this.parseOutput(target1, target2, executor);
    }

    @Override
    public void unifiedDiff(@NotNull SvnTarget target1, @NotNull SvnTarget target2, @NotNull OutputStream output) throws VcsException {
        this.assertUrl(target1);
        this.assertUrl(target2);
        ArrayList parameters = ContainerUtil.newArrayList();
        CommandUtil.put((List<String>)parameters, target1);
        CommandUtil.put((List<String>)parameters, target2);
        CommandExecutor executor = this.execute(this.myVcs, target1, SvnCommandName.diff, parameters, null);
        try {
            executor.getBinaryOutput().writeTo(output);
        }
        catch (IOException e) {
            throw new SvnBindException(e);
        }
    }

    @NotNull
    private List<Change> parseOutput(@NotNull SvnTarget target1, @NotNull SvnTarget target2, @NotNull CommandExecutor executor) throws SvnBindException {
        try {
            DiffInfo diffInfo = CommandUtil.parse(executor.getOutput(), DiffInfo.class);
            ArrayList result = ContainerUtil.newArrayList();
            if (diffInfo != null) {
                for (DiffPath path : diffInfo.diffPaths) {
                    result.add(this.createChange(target1, target2, path));
                }
            }
            return result;
        }
        catch (JAXBException e) {
            throw new SvnBindException(e);
        }
    }

    @NotNull
    private ContentRevision createRevision(@NotNull FilePath path, @NotNull FilePath localPath, @NotNull SVNRevision revision, @NotNull FileStatus status) {
        Object result = path.isNonLocal() ? SvnRepositoryContentRevision.create(this.myVcs, path, (FilePath)(status == FileStatus.DELETED ? localPath : null), revision.getNumber()) : CurrentContentRevision.create((FilePath)path);
        return result;
    }

    private static FilePath createFilePath(@NotNull SvnTarget target, boolean isDirectory) {
        return target.isFile() ? VcsUtil.getFilePath((File)target.getFile(), (boolean)isDirectory) : VcsUtil.getFilePathOnNonLocal((String)SvnUtil.toDecodedString(target), (boolean)isDirectory);
    }

    @NotNull
    private Change createChange(@NotNull SvnTarget target1, @NotNull SvnTarget target2, @NotNull DiffPath diffPath) throws SvnBindException {
        SvnTarget subTarget1 = SvnUtil.append(target1, diffPath.path, true);
        String relativePath = SvnUtil.getRelativeUrl(SvnUtil.toDecodedString(target1), SvnUtil.toDecodedString(subTarget1));
        if (relativePath == null) {
            throw new SvnBindException("Could not get relative path for " + target1 + " and " + subTarget1);
        }
        SvnTarget subTarget2 = SvnUtil.append(target2, FileUtil.toSystemIndependentName((String)relativePath));
        FilePath target1Path = CmdDiffClient.createFilePath(subTarget1, diffPath.isDirectory());
        FilePath target2Path = CmdDiffClient.createFilePath(subTarget2, diffPath.isDirectory());
        FileStatus status = SvnStatusConvertor.convertStatus(SvnStatusHandler.getStatus(diffPath.itemStatus), SvnStatusHandler.getStatus(diffPath.propertiesStatus));
        ContentRevision beforeRevision = status == FileStatus.ADDED ? null : this.createRevision(target1Path, target2Path, target1.getPegRevision(), status);
        ContentRevision afterRevision = status == FileStatus.DELETED ? null : this.createRevision(target2Path, target1Path, target2.getPegRevision(), status);
        return CmdDiffClient.createChange(status, beforeRevision, afterRevision);
    }

    @NotNull
    private static Change createChange(@NotNull FileStatus status, @Nullable ContentRevision beforeRevision, @Nullable ContentRevision afterRevision) {
        return new Change(beforeRevision, afterRevision, status){

            public boolean isRenamed() {
                return false;
            }

            public boolean isMoved() {
                return false;
            }
        };
    }

    public static class DiffPath {
        @XmlAttribute(name="kind", required=true)
        public NodeKind kind;
        @XmlAttribute(name="props")
        public String propertiesStatus;
        @XmlAttribute(name="item")
        public String itemStatus;
        @XmlValue
        public String path;

        public boolean isDirectory() {
            return this.kind.isDirectory();
        }
    }

    @XmlRootElement(name="diff")
    public static class DiffInfo {
        @XmlElementWrapper(name="paths")
        @XmlElement(name="path")
        public List<DiffPath> diffPaths = new ArrayList<DiffPath>();
    }
}

